function dydt=Squalene_chem_clothing_F(t,y)

global K_clothing kg kbr S_clothing V_room Porosity
global Clothes_fraction_air Clothes_fraction_fibres
global NCom L_layers hm delta_clothes Dg ratio_p
global V_clothes A ratio_s AER Production_O3
global Travel_distance delta_oil delta_sc delta_ve
global gap_length oil_layers sc_layers ve_layers K
global sigma_1 W_vel delta_x_1 a0_1 kd_1 ka
global Db_oil Db_oil_2 Db_sc Db_ve V_gap V_mfp V_oil V_sc V_ve

%---------Initialise matrix sizes-----------
dydt=zeros(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*ve_layers+48,1); k_gas_clothes=zeros(47);
k_clothes_gas=zeros(48); kclothes_bl=zeros(48);
kclothes_bb=zeros(48); k_room_bl=zeros(48); Jbl_clothes=zeros(21);
Fnet=zeros(21); Jclothes_bl=zeros(21); Jgas_clothes=zeros(21,L_layers);
kclothes_gap=zeros(21); kgap_mfp=zeros(21); Jclothes_gas=zeros(21,L_layers); Jclothes_clothes=zeros(21,L_layers,L_layers);
allCI=zeros(L_layers+oil_layers+sc_layers+ve_layers); allcarbonyl=zeros(L_layers+oil_layers+sc_layers+ve_layers);
Pr=zeros(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*ve_layers+48,1);
%----------------------------

Thetas=sigma_1(1)*y(NCom*L_layers+15+69+1)+sigma_1(2)*y(NCom*L_layers+15+69+2)+...
    sigma_1(3)*y(NCom*L_layers+15+69+3)+sigma_1(4)*y(NCom*L_layers+15+69+4)+...
    sigma_1(5)*y(NCom*L_layers+15+69+5)+sigma_1(6)*y(NCom*L_layers+15+69+6)+...
    sigma_1(14)*y(NCom*L_layers+15+69+14)+sigma_1(15)*y(NCom*L_layers+15+69+15)+...
    sigma_1(16)*y(NCom*L_layers+15+69+16)+sigma_1(17)*y(NCom*L_layers+15+69+17)+...
    sigma_1(18)*y(NCom*L_layers+15+69+18)+sigma_1(19)*y(NCom*L_layers+15+69+19)+...
    sigma_1(20)*y(NCom*L_layers+15+69+20)+sigma_1(21)*y(NCom*L_layers+15+69+21); %Sorption layer sace coverage

%%%%%%%---------Kinetic parameters for mass transport-------------%%%%%%%%

for i=[1,2,3,4,6,7,20,21,22,23,24,26,46,47]
    k_gas_clothes(i)=1e8; % Transport from the clothing gas phase to the clothing condensed phase (cm s-1) %Set to be high for instantaneous partitioning
    k_clothes_gas(i)=(k_gas_clothes(i))./K_clothing(i); %Transport from the clothing condensed phase to the clothing gas phase (cm s-1)
    kclothes_bl(i)=hm(i)*2+2*Dg(i)./delta_clothes; %bulk transport between the boundary layer and the clothing (cm s-1)
    kclothes_bb(i)=Dg(i)*Porosity./delta_clothes; %bulk transport in the gas-phase clothing (cm s-1)
    k_room_bl(i)=2*hm(i); %bulk transport between the room and the gas-phase near the clothing (cm s-1)
end

for i=1:4
ratio_gap_clothes=gap_length./(delta_clothes+gap_length);
    kclothes_gap(i)=(Dg(i).*ratio_gap_clothes+Dg(i).*Porosity.*(1-ratio_gap_clothes))./(gap_length/2+delta_clothes/2); %bulk transport between the gap and the gas phase in the clothing (cm s-1)
    kgap_mfp(i)=Dg(i)./(gap_length/2); %Transport rate from the gap to the mfp above the skin (cm s-1)
    koil1_s(i)=Db_oil_2(i)./(delta_oil./2+delta_x_1(i)./2); %Transport rate from the skin oil to sorption layer transport (cm s-1)
    ks_oil1(i)=(K(i).*koil1_s(i).*kd_1(i))/(ka(i).*(1-Thetas)); %Transport rate from the sorption layer to the skin oil for volatile species (s-1)
end
for i=5:6
ratio_gap_clothes=gap_length./(delta_clothes+gap_length);
    kclothes_gap(i)=(Dg(i+1).*ratio_gap_clothes+Dg(i).*Porosity.*(1-ratio_gap_clothes))./(gap_length/2+delta_clothes/2);%bulk transport between the gap and the gas phase in the clothing (cm s-1)
    kgap_mfp(i)=Dg(i+1)./(gap_length/2); %Transport rate from the gap to the mfp above the skin (cm s-1)
    koil1_s(i)=Db_oil_2(i)./(delta_oil./2+delta_x_1(i)./2); %Transport rate from the skin oil to sorption layer transport (cm s-1)
    ks_oil1(i)=(K(i+1).*koil1_s(i).*kd_1(i))/(ka(i).*(1-Thetas)); %Transport rate from the sorption layer to the skin oil for volatile species (s-1)
end

for i=14:18
ratio_gap_clothes=gap_length./(delta_clothes+gap_length);
    kclothes_gap(i)=(Dg(i+6).*ratio_gap_clothes+Dg(i).*Porosity.*(1-ratio_gap_clothes))./(gap_length/2+delta_clothes/2); %bulk transport between the gap and the gas phase in the clothing (cm s-1)
    kgap_mfp(i)=Dg(i+6)./(gap_length/2); %Transport rate from the gap to the mfp above the skin (cm s-1)
        koil1_s(i)=Db_oil_2(i)./(delta_oil./2+delta_x_1(i)./2); %Transport rate from the skin oil to sorption layer transport (cm s-1)
    ks_oil1(i)=(K(i+6).*koil1_s(i).*kd_1(i))/(ka(i).*(1-Thetas)); %Transport rate from the sorption layer to the skin oil for volatile species (s-1)
end

for i=19
ratio_gap_clothes=gap_length./(delta_clothes+gap_length);
    kclothes_gap(i)=(Dg(i+7).*ratio_gap_clothes+Dg(i).*Porosity.*(1-ratio_gap_clothes))./(gap_length/2+delta_clothes/2); %bulk transport between the gap and the gas phase in the clothing (cm s-1)
    kgap_mfp(i)=Dg(i+7)./(gap_length/2); %Transport rate from the gap to the mfp above the skin (cm s-1)
            koil1_s(i)=Db_oil_2(i)./(delta_oil./2+delta_x_1(i)./2); %Transport rate from the skin oil to sorption layer transport (cm s-1)
    ks_oil1(i)=(K(i+7).*koil1_s(i).*kd_1(i))/(ka(i).*(1-Thetas)); %Transport rate from the sorption layer to the skin oil for volatile species (s-1)
end

for i=20:21
ratio_gap_clothes=gap_length./(delta_clothes+gap_length);
    kclothes_gap(i)=(Dg(i+26).*ratio_gap_clothes+Dg(i).*Porosity.*(1-ratio_gap_clothes))./(gap_length/2+delta_clothes/2);
    kgap_mfp(i)=Dg(i+26)./(gap_length/2); %Transport rate from the gap to the mfp above the skin (cm s-1)
            koil1_s(i)=Db_oil_2(i)./(delta_oil./2+delta_x_1(i)./2); %Transport rate from the skin oil to sorption layer transport (cm s-1)
    ks_oil1(i)=(K(i+26).*koil1_s(i).*kd_1(i))/(ka(i).*(1-Thetas)); %Transport rate from the sorption layer to the skin oil for volatile species (s-1)
end

for i=1:48
    ratio_oil_sc=delta_oil./(delta_oil+delta_sc); %ratio of the thickness of 1 layer of the skin oil  to the total thickness of the 1 layer of the skin oil + 1 layer of the stratum corneum
    ratio_sc_ve=delta_sc./(delta_sc+delta_ve); %ratio of the thickness of 1 layer of the stratum corneum  to the total thickness of the 1 layer of the stratum corneum + 1 layer of the viable epidermis
    kfinaloil_sc(i)=(Db_oil(i)*ratio_oil_sc+Db_sc(i)*(1-ratio_oil_sc))./(delta_oil/2+delta_sc/2); %bulk transport between the skin oil and stratum corneum (cm s-1)
    ksc_ve(i)=(Db_sc(i)*ratio_sc_ve+Db_ve(i)*(1-ratio_sc_ve))./(delta_sc/2+delta_ve/2); %bulk transport between the stratum corneum and viable epidermis (cm s-1)
    koil_oil(i)=Db_oil(i)./delta_oil; %bulk transport in the skin oil (cm s-1)
    ksc_sc(i)=Db_sc(i)./delta_sc; %bulk transport in the stratum corneum (cm s-1)
    kve_ve(i)=Db_ve(i)./delta_ve; %bulk transport in the viable epidermis (cm s-1)
    kve_blood(i)=99999; %Transport into the blood (cm s-1) set to be high to maintain rapid transport into the blood
end

k_oil_clothes=2.8e-10; %Contact transfer coefficient from the skin oil to the clothing (cm s-1)
k_clothes_oil=k_oil_clothes; %Contact transfer coefficient from the clothing to the skin oil (cm s-1)

%-----Transport fluxes for volatile species------

for i=1:4 
        Joil1_s(i)=koil1_s(i).*y(NCom*L_layers+105+i); %Flux of volatile species from the skin oil to the sorption layer (cm-2 s-1)
        Jclothes_bl(i)=kclothes_bl(i)*y(48+i); %Flux between the clothing gas-phase to the gas phase near the clothing (cm-2 s-1)
        Jbl_clothes(i)=kclothes_bl(i)*y(NCom*L_layers+i); %Flux the gas phase near the clothing to the clothing gas phase (cm-2 s-1)
        Fnet(i)=k_room_bl(i)*(y(NCom*L_layers+21+i)-y(NCom*L_layers+i)); %Net flux between the gas-phase and gas phase near the clothing (cm-2 s-1)
    for m=1:L_layers
        Jgas_clothes(i,m)=k_gas_clothes(i)*y(NCom*(m-1)+48+i);  %Flux from the clothing gas phase to the clothing condensed phase (cm-2 s-1)
        Jclothes_gas(i,m)=k_clothes_gas(i)*y(NCom*(m-1)+i); %Flux from the clothing condensed phase to the clothing gas phase (cm-2 s-1)
    end
    for m=1:L_layers-1
        Jclothes_clothes(i,m,m+1)=kclothes_bb(i)*y(NCom*(m-1)+48+i); %Fluxes between gas phase layers in the clothing (cm-2 s-1)
        Jclothes_clothes(i,m+1,m)=kclothes_bb(i)*y(NCom*m+48+i); %Fluxes between gas phase layers in the clothing (cm-2 s-1)
    end
end

for i=5:6
        Joil1_s(i)=koil1_s(i).*y(NCom*L_layers+105+i+1); %Flux of volatile species from the skin oil to the sorption layer (cm-2 s-1)
        Jclothes_bl(i)=kclothes_bl(i+1)*y(48+i);%Flux between the clothing gas-phase to the gas phase near the clothing (cm-2 s-1)
        Jbl_clothes(i)=kclothes_bl(i+1)*y(NCom*L_layers+i); %Flux the gas phase near the clothing to the clothing gas phase (cm-2 s-1)
        Fnet(i)=k_room_bl(i+1)*(y(NCom*L_layers+21+i)-y(NCom*L_layers+i)); %Net flux between the gas-phase and gas phase near the clothing (cm-2 s-1)
    for m=1:L_layers
        Jgas_clothes(i,m)=k_gas_clothes(i+1)*y(NCom*(m-1)+48+i); %Flux from the clothing gas phase to the clothing condensed phase (cm-2 s-1)
        Jclothes_gas(i,m)=k_clothes_gas(i+1)*y(NCom*(m-1)+i+1); %Flux from the clothing condensed phase to the clothing gas phase (cm-2 s-1)
    end
    for m=1:L_layers-1
        Jclothes_clothes(i,m,m+1)=kclothes_bb(i+1)*y(NCom*(m-1)+48+i); %Fluxes between gas phase layers in the clothing (cm-2 s-1)
        Jclothes_clothes(i,m+1,m)=kclothes_bb(i+1)*y(NCom*m+48+i); %Fluxes between gas phase layers in the clothing (cm-2 s-1)
    end
end
for i=14:18
        Joil1_s(i)=koil1_s(i).*y(NCom*L_layers+105+i+6); %Flux of volatile species from the skin oil to the sorption layer (cm-2 s-1)
        Jclothes_bl(i)=kclothes_bl(i+6)*y(48+i); %Flux between the clothing gas-phase to the gas phase near the clothing (cm-2 s-1)
        Jbl_clothes(i)=kclothes_bl(i+6)*y(NCom*L_layers+i); %Flux the gas phase near the clothing to the clothing gas phase (cm-2 s-1)
        Fnet(i)=k_room_bl(i+6)*(y(NCom*L_layers+21+i)-y(NCom*L_layers+i)); %Net flux between the gas-phase and gas phase near the clothing (cm-2 s-1)
    for m=1:L_layers
        Jgas_clothes(i,m)=k_gas_clothes(i+6)*y(NCom*(m-1)+48+i); %Flux from the clothing gas phase to the clothing condensed phase (cm-2 s-1)
        Jclothes_gas(i,m)=k_clothes_gas(i+6)*y(NCom*(m-1)+i+6); %Flux from the clothing condensed phase to the clothing gas phase (cm-2 s-1)
    end
    for m=1:L_layers-1
        Jclothes_clothes(i,m,m+1)=kclothes_bb(i+6)*y(NCom*(m-1)+48+i); %Fluxes between gas phase layers in the clothing (cm-2 s-1)
        Jclothes_clothes(i,m+1,m)=kclothes_bb(i+6)*y(NCom*m+48+i); %Fluxes between gas phase layers in the clothing (cm-2 s-1)
    end
end
for i=19
       Joil1_s(i)=koil1_s(i).*y(NCom*L_layers+105+i+7); %Flux of volatile species from the skin oil to the sorption layer (cm-2 s-1)
       Jclothes_bl(i)=kclothes_bl(i+7)*y(48+i); %Flux between the clothing gas-phase to the gas phase near the clothing (cm-2 s-1) 
       Jbl_clothes(i)=kclothes_bl(i+7)*y(NCom*L_layers+i); %Flux the gas phase near the clothing to the clothing gas phase (cm-2 s-1)
       Fnet(i)=k_room_bl(i+7)*(y(NCom*L_layers+21+i)-y(NCom*L_layers+i)); %Net flux between the gas-phase and gas phase near the clothing (cm-2 s-1)
    for m=1:L_layers
        Jgas_clothes(i,m)=k_gas_clothes(i+7)*y(NCom*(m-1)+48+i); %Flux from the clothing gas phase to the clothing condensed phase (cm-2 s-1)
        Jclothes_gas(i,m)=k_clothes_gas(i+7)*y(NCom*(m-1)+i+7); %Flux from the clothing condensed phase to the clothing gas phase (cm-2 s-1)
    end
    for m=1:L_layers-1
        Jclothes_clothes(i,m,m+1)=kclothes_bb(i+7)*y(NCom*(m-1)+48+i); %Fluxes between gas phase layers in the clothing (cm-2 s-1)
        Jclothes_clothes(i,m+1,m)=kclothes_bb(i+7)*y(NCom*m+48+i); %Fluxes between gas phase layers in the clothing (cm-2 s-1)
    end
end
for i=20:21
        Joil1_s(i)=koil1_s(i).*y(NCom*L_layers+105+i+26); %Flux of volatile species from the skin oil to the sorption layer (cm-2 s-1)
        Jclothes_bl(i)=kclothes_bl(i+26)*y(48+i); %Flux between the clothing gas-phase to the gas phase near the clothing (cm-2 s-1)
        Jbl_clothes(i)=kclothes_bl(i+26)*y(NCom*L_layers+i); %Flux the gas phase near the clothing to the clothing gas phase (cm-2 s-1)
        Fnet(i)=k_room_bl(i+26)*(y(NCom*L_layers+21+i)-y(NCom*L_layers+i)); %Net flux between the gas-phase and gas phase near the clothing (cm-2 s-1)
    for m=1:L_layers
        Jgas_clothes(i,m)=k_gas_clothes(i+26)*y(NCom*(m-1)+48+i); %Flux from the clothing gas phase to the clothing condensed phase (cm-2 s-1)
        Jclothes_gas(i,m)=k_clothes_gas(i+26)*y(NCom*(m-1)+i+26); %Flux from the clothing condensed phase to the clothing gas phase (cm-2 s-1)
    end
    for m=1:L_layers-1
        Jclothes_clothes(i,m,m+1)=kclothes_bb(i+26)*y(NCom*(m-1)+48+i); %Fluxes between gas phase layers in the clothing (cm-2 s-1)
        Jclothes_clothes(i,m+1,m)=kclothes_bb(i+26)*y(NCom*m+48+i); %Fluxes between gas phase layers in the clothing (cm-2 s-1)
    end
end


for i=1:21     
    Jcl_gap(i)=kclothes_gap(i).*y(NCom*(L_layers-1)+48+i); %from the bottom of the clothing to the gap between the clothing and skin (cm-2 s-1)
    Jgap_cl(i)=kclothes_gap(i).*y(NCom*L_layers-6+48+i); %from the gap between the clothing and skin to the bottom of the clothing (cm-2 s-1)
    Jgap_mfp(i)=kgap_mfp(i).*y(NCom*L_layers-6+48+i); % from the gap to the mfp above the skin (cm-2 s-1)
    Jmfp_gap(i)=kgap_mfp(i).*y(NCom*L_layers+15+48+i); % from the mfp above the skin to the gap (cm-2 s-1)
    Jcoll(i)=W_vel(i)./4.*y(NCom*L_layers+15+48+i); %Collision flux of volatile species to the skin sace (cm-2 s-1)
    Jads(i)=a0_1(i).*(1-Thetas).*Jcoll(i); %Adsorption flux of volatile species to the skin sace (cm-2 s-1)
    Jdes(i)=kd_1(i)*y(NCom*L_layers+15+69+i); %Desorption flux of volatile species from the skin sace (cm-2 s-1)
    Js_oil1(i)=ks_oil1(i).*y(NCom*L_layers+15+69+i); %Flux of volatile species from the sorption layer to the skin oil (cm-2 s-1)
end

%%%%%%%-------Transport fluxes for all species-----%%%%%%

for i=1:48
    Jfinaloil_sc(i)=kfinaloil_sc(i).*y(NCom*L_layers+105+48*(oil_layers-1)+i);%from the skin oil to the stratum corneum (cm-2 s-1)
    Jsc_finaloil(i)=kfinaloil_sc(i).*y(NCom*L_layers+105+oil_layers*48+i); %from the stratum corneum to the skin oil (cm-2 s-1)
    Jsc_ve(i)=ksc_ve(i).*y(NCom*L_layers+105+oil_layers*48+48*(sc_layers-1)+i); %from the stratum corneum to the viable epidermis (cm-2 s-1)
    Jve_sc(i)=ksc_ve(i).*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+i);%from the viable epidermis to the stratum corneum (cm-2 s-1)
    Jve_blood(i)=kve_blood(i).*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*ve_layers+i); %from the viable epidermis into the blood (cm-2 s-1)

%Fluxes between the skin oil layers (cm-2 s-1)
for m=1:oil_layers-1
    Joil_oil(i,m,m+1)=koil_oil(i).*y(NCom*L_layers+105+48*(m-1)+i);
    Joil_oil(i,m+1,m)=koil_oil(i).*y(NCom*L_layers+105+48*(m)+i);
end

%Fluxes between the stratum corneum layers (cm-2 s-1)
for m=1:sc_layers-1
    Jsc_sc(i,m,m+1)=ksc_sc(i)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+i);
    Jsc_sc(i,m+1,m)=ksc_sc(i)*y(NCom*L_layers+105+oil_layers*48+48*(m)+i);
end
%Fluxes between the viable epidermis layers (cm-2 s-1)
for m=1:ve_layers-1
    Jve_ve(i,m,m+1)=kve_ve(i)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+i);
    Jve_ve(i,m+1,m)=kve_ve(i)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m)+i);
end
end

%%%contact transport%%%%

for i=[1:20,22:25,28:48]
    Jso_cl_total(i)=k_oil_clothes.*y(NCom*L_layers+105+i); % Contact transfer flux from the skin oil to the clothing (cm-2 s-1)
    for m=1:L_layers
        Jcl_so(i,m)=k_clothes_oil.*y(NCom*(m-1)+i); % Contact transfer flux from the clothing to the skin oil (cm-2 s-1)
    end
end

for i=[1:20,22:25,28:48]
   Jcl_so_total(i)=sum(Jcl_so(i,1:L_layers)); % Sum of the contact transfers for all clothing layers (cm-2 s-1)
end

%%%%%%%--------------Production and loss rates (cm-3 s-1)-----------------%%%%%%%

%%%%%%%------------In the gas phase (main room, includes air-exchange)------------%%%%%%%
%4-MOD
Pr(NCom*L_layers-27+49)=-AER*y(NCom*L_layers-27+49)-kg(4)*y(NCom*L_layers-27+49)*y(NCom*L_layers-27+67);
%4-MON
Pr(NCom*L_layers-27+50)=-AER*y(NCom*L_layers-27+50)-kg(3)*y(NCom*L_layers-27+50)*y(NCom*L_layers-27+67)+(1/4)*kg(1)*y(NCom*L_layers-27+62)*y(NCom*L_layers-27+67)+1*kg(15)*y(NCom*L_layers-27+60)*y(NCom*L_layers-27+63)+1*kg(16)*y(NCom*L_layers-27+60)*y(NCom*L_layers-27+67);
%4-OPA
Pr(NCom*L_layers-27+51)=-AER*y(NCom*L_layers-27+51)+(1/4)*kg(1)*y(NCom*L_layers-27+62)*y(NCom*L_layers-27+67)+(1/2)*kg(2)*y(NCom*L_layers-27+52)*y(NCom*L_layers-27+67)+2*(1/2)*kg(3)*y(NCom*L_layers-27+50)*y(NCom*L_layers-27+67)+(1/2)*kg(4)*y(NCom*L_layers-27+49)*y(NCom*L_layers-27+67)+1*kg(12)*y(NCom*L_layers-27+59)*y(NCom*L_layers-27+63)+1*kg(13)*y(NCom*L_layers-27+59)*y(NCom*L_layers-27+67)+1*kg(21)*y(NCom*L_layers-27+56)*y(NCom*L_layers-27+63)+1*kg(22)*y(NCom*L_layers-27+56)*y(NCom*L_layers-27+67);
%6-MHO
Pr(NCom*L_layers-27+52)=-AER*y(NCom*L_layers-27+52)-kg(2)*y(NCom*L_layers-27+52)*y(NCom*L_layers-27+67)+(1/4)*kg(1)*y(NCom*L_layers-27+62)*y(NCom*L_layers-27+67)+1*kg(9)*y(NCom*L_layers-27+57)*y(NCom*L_layers-27+63)+1*kg(10)*y(NCom*L_layers-27+57)*y(NCom*L_layers-27+67);
%CA1
Pr(NCom*L_layers-27+53)=-AER*y(NCom*L_layers-27+53)+1*kg(14)*y(NCom*L_layers-27+59);
%CA2
Pr(NCom*L_layers-27+54)=-AER*y(NCom*L_layers-27+54)+1*kg(20)*y(NCom*L_layers-27+61);
%CI1
Pr(NCom*L_layers-27+55)=-kg(6)*y(NCom*L_layers-27+55)*y(NCom*L_layers-27+63)-kg(7)*y(NCom*L_layers-27+55)*y(NCom*L_layers-27+67)-kg(8)*y(NCom*L_layers-27+55)+(1/4)*kg(1)*y(NCom*L_layers-27+62)*y(NCom*L_layers-27+67)+(1/2)*kg(2)*y(NCom*L_layers-27+52)*y(NCom*L_layers-27+67)+(1/2)*kg(5)*y(NCom*L_layers-27+66)*y(NCom*L_layers-27+67);
%CI12
Pr(NCom*L_layers-27+56)=-kg(21)*y(NCom*L_layers-27+56)*y(NCom*L_layers-27+63)-kg(22)*y(NCom*L_layers-27+56)*y(NCom*L_layers-27+67)-kg(23)*y(NCom*L_layers-27+56)+(1/2)*kg(3)*y(NCom*L_layers-27+50)*y(NCom*L_layers-27+67)+(1/2)*kg(4)*y(NCom*L_layers-27+49)*y(NCom*L_layers-27+67);
%CI2
Pr(NCom*L_layers-27+57)=-kg(9)*y(NCom*L_layers-27+57)*y(NCom*L_layers-27+63)-kg(10)*y(NCom*L_layers-27+57)*y(NCom*L_layers-27+67)-kg(11)*y(NCom*L_layers-27+57)+(1/4)*kg(1)*y(NCom*L_layers-27+62)*y(NCom*L_layers-27+67);
%CI20
Pr(NCom*L_layers-27+58)=-kg(24)*y(NCom*L_layers-27+58)*y(NCom*L_layers-27+63)-kg(25)*y(NCom*L_layers-27+58)*y(NCom*L_layers-27+67)-kg(26)*y(NCom*L_layers-27+58)+(1/2)*kg(5)*y(NCom*L_layers-27+66)*y(NCom*L_layers-27+67);
%CI7
Pr(NCom*L_layers-27+59)=-kg(12)*y(NCom*L_layers-27+59)*y(NCom*L_layers-27+63)-kg(13)*y(NCom*L_layers-27+59)*y(NCom*L_layers-27+67)-kg(14)*y(NCom*L_layers-27+59)+(1/4)*kg(1)*y(NCom*L_layers-27+62)*y(NCom*L_layers-27+67)+(1/2)*kg(2)*y(NCom*L_layers-27+52)*y(NCom*L_layers-27+67)+(1/2)*kg(3)*y(NCom*L_layers-27+50)*y(NCom*L_layers-27+67);
%CI8
Pr(NCom*L_layers-27+60)=-kg(15)*y(NCom*L_layers-27+60)*y(NCom*L_layers-27+63)-kg(16)*y(NCom*L_layers-27+60)*y(NCom*L_layers-27+67)-kg(17)*y(NCom*L_layers-27+60)+(1/4)*kg(1)*y(NCom*L_layers-27+62)*y(NCom*L_layers-27+67);
%CI9
Pr(NCom*L_layers-27+61)=-kg(18)*y(NCom*L_layers-27+61)*y(NCom*L_layers-27+63)-kg(19)*y(NCom*L_layers-27+61)*y(NCom*L_layers-27+67)-kg(20)*y(NCom*L_layers-27+61)+(1/2)*kg(4)*y(NCom*L_layers-27+49)*y(NCom*L_layers-27+67);
%Geranyl acetone
Pr(NCom*L_layers-27+62)=-AER*y(NCom*L_layers-27+62)-kg(1)*y(NCom*L_layers-27+62)*y(NCom*L_layers-27+67);
%H2O
Pr(NCom*L_layers-27+63)=-AER*y(NCom*L_layers-27+63)-kg(6)*y(NCom*L_layers-27+55)*y(NCom*L_layers-27+63)-kg(9)*y(NCom*L_layers-27+57)*y(NCom*L_layers-27+63)-kg(12)*y(NCom*L_layers-27+59)*y(NCom*L_layers-27+63)-kg(15)*y(NCom*L_layers-27+60)*y(NCom*L_layers-27+63)-kg(18)*y(NCom*L_layers-27+61)*y(NCom*L_layers-27+63)-kg(21)*y(NCom*L_layers-27+56)*y(NCom*L_layers-27+63)-kg(24)*y(NCom*L_layers-27+58)*y(NCom*L_layers-27+63);
%HK1
Pr(NCom*L_layers-27+64)=-AER*y(NCom*L_layers-27+64)+1*kg(8)*y(NCom*L_layers-27+55);
%HK2
Pr(NCom*L_layers-27+65)=-AER*y(NCom*L_layers-27+65)+(1/2)*kg(5)*y(NCom*L_layers-27+66)*y(NCom*L_layers-27+67)+1*kg(23)*y(NCom*L_layers-27+56)+1*kg(24)*y(NCom*L_layers-27+58)*y(NCom*L_layers-27+63)+1*kg(25)*y(NCom*L_layers-27+58)*y(NCom*L_layers-27+67);
%HK3
Pr(NCom*L_layers-27+66)=-AER*y(NCom*L_layers-27+66)-kg(5)*y(NCom*L_layers-27+66)*y(NCom*L_layers-27+67)+1*kg(11)*y(NCom*L_layers-27+57);
%O3
Pr(NCom*L_layers-27+67)=Production_O3-AER*y(NCom*L_layers-27+67)-kg(1)*y(NCom*L_layers-27+62)*y(NCom*L_layers-27+67)-kg(2)*y(NCom*L_layers-27+52)*y(NCom*L_layers-27+67)-kg(3)*y(NCom*L_layers-27+50)*y(NCom*L_layers-27+67)-kg(4)*y(NCom*L_layers-27+49)*y(NCom*L_layers-27+67)-kg(5)*y(NCom*L_layers-27+66)*y(NCom*L_layers-27+67)-kg(7)*y(NCom*L_layers-27+55)*y(NCom*L_layers-27+67)-kg(10)*y(NCom*L_layers-27+57)*y(NCom*L_layers-27+67)-kg(13)*y(NCom*L_layers-27+59)*y(NCom*L_layers-27+67)-kg(16)*y(NCom*L_layers-27+60)*y(NCom*L_layers-27+67)-kg(19)*y(NCom*L_layers-27+61)*y(NCom*L_layers-27+67)-kg(22)*y(NCom*L_layers-27+56)*y(NCom*L_layers-27+67)-kg(25)*y(NCom*L_layers-27+58)*y(NCom*L_layers-27+67);
%acetone
Pr(NCom*L_layers-27+68)=-AER*y(NCom*L_layers-27+68)+(1/4)*kg(1)*y(NCom*L_layers-27+62)*y(NCom*L_layers-27+67)+(1/2)*kg(2)*y(NCom*L_layers-27+52)*y(NCom*L_layers-27+67)+(1/2)*kg(5)*y(NCom*L_layers-27+66)*y(NCom*L_layers-27+67)+1*kg(6)*y(NCom*L_layers-27+55)*y(NCom*L_layers-27+63)+1*kg(7)*y(NCom*L_layers-27+55)*y(NCom*L_layers-27+67);
%1,4 butanedial
Pr(NCom*L_layers-27+69)=-AER*y(NCom*L_layers-27+69)+(1/2)*kg(4)*y(NCom*L_layers-27+49)*y(NCom*L_layers-27+67)+1*kg(18)*y(NCom*L_layers-27+61)*y(NCom*L_layers-27+63)+1*kg(19)*y(NCom*L_layers-27+61)*y(NCom*L_layers-27+67);

%%%%%%%------------In the near sace gas phase ------------%%%%%%%
%4-MOD
Pr(NCom*L_layers+15+49)=-kg(4)*y(NCom*L_layers+15+49)*y(NCom*L_layers+15+67);
%4-MON
Pr(NCom*L_layers+15+50)=-kg(3)*y(NCom*L_layers+15+50)*y(NCom*L_layers+15+67)+(1/4)*kg(1)*y(NCom*L_layers+15+62)*y(NCom*L_layers+15+67)+1*kg(15)*y(NCom*L_layers+15+60)*y(NCom*L_layers+15+63)+1*kg(16)*y(NCom*L_layers+15+60)*y(NCom*L_layers+15+67);
%4-OPA
Pr(NCom*L_layers+15+51)=+(1/4)*kg(1)*y(NCom*L_layers+15+62)*y(NCom*L_layers+15+67)+(1/2)*kg(2)*y(NCom*L_layers+15+52)*y(NCom*L_layers+15+67)+2*(1/2)*kg(3)*y(NCom*L_layers+15+50)*y(NCom*L_layers+15+67)+(1/2)*kg(4)*y(NCom*L_layers+15+49)*y(NCom*L_layers+15+67)+1*kg(12)*y(NCom*L_layers+15+59)*y(NCom*L_layers+15+63)+1*kg(13)*y(NCom*L_layers+15+59)*y(NCom*L_layers+15+67)+1*kg(21)*y(NCom*L_layers+15+56)*y(NCom*L_layers+15+63)+1*kg(22)*y(NCom*L_layers+15+56)*y(NCom*L_layers+15+67);
%6-MHO
Pr(NCom*L_layers+15+52)=-kg(2)*y(NCom*L_layers+15+52)*y(NCom*L_layers+15+67)+(1/4)*kg(1)*y(NCom*L_layers+15+62)*y(NCom*L_layers+15+67)+1*kg(9)*y(NCom*L_layers+15+57)*y(NCom*L_layers+15+63)+1*kg(10)*y(NCom*L_layers+15+57)*y(NCom*L_layers+15+67);
%CA1
Pr(NCom*L_layers+15+53)=+1*kg(14)*y(NCom*L_layers+15+59);
%CA2
Pr(NCom*L_layers+15+54)=+1*kg(20)*y(NCom*L_layers+15+61);
%CI1
Pr(NCom*L_layers+15+55)=-kg(6)*y(NCom*L_layers+15+55)*y(NCom*L_layers+15+63)-kg(7)*y(NCom*L_layers+15+55)*y(NCom*L_layers+15+67)-kg(8)*y(NCom*L_layers+15+55)+(1/4)*kg(1)*y(NCom*L_layers+15+62)*y(NCom*L_layers+15+67)+(1/2)*kg(2)*y(NCom*L_layers+15+52)*y(NCom*L_layers+15+67)+(1/2)*kg(5)*y(NCom*L_layers+15+66)*y(NCom*L_layers+15+67);
%CI12
Pr(NCom*L_layers+15+56)=-kg(21)*y(NCom*L_layers+15+56)*y(NCom*L_layers+15+63)-kg(22)*y(NCom*L_layers+15+56)*y(NCom*L_layers+15+67)-kg(23)*y(NCom*L_layers+15+56)+(1/2)*kg(3)*y(NCom*L_layers+15+50)*y(NCom*L_layers+15+67)+(1/2)*kg(4)*y(NCom*L_layers+15+49)*y(NCom*L_layers+15+67);
%CI2
Pr(NCom*L_layers+15+57)=-kg(9)*y(NCom*L_layers+15+57)*y(NCom*L_layers+15+63)-kg(10)*y(NCom*L_layers+15+57)*y(NCom*L_layers+15+67)-kg(11)*y(NCom*L_layers+15+57)+(1/4)*kg(1)*y(NCom*L_layers+15+62)*y(NCom*L_layers+15+67);
%CI20
Pr(NCom*L_layers+15+58)=-kg(24)*y(NCom*L_layers+15+58)*y(NCom*L_layers+15+63)-kg(25)*y(NCom*L_layers+15+58)*y(NCom*L_layers+15+67)-kg(26)*y(NCom*L_layers+15+58)+(1/2)*kg(5)*y(NCom*L_layers+15+66)*y(NCom*L_layers+15+67);
%CI7
Pr(NCom*L_layers+15+59)=-kg(12)*y(NCom*L_layers+15+59)*y(NCom*L_layers+15+63)-kg(13)*y(NCom*L_layers+15+59)*y(NCom*L_layers+15+67)-kg(14)*y(NCom*L_layers+15+59)+(1/4)*kg(1)*y(NCom*L_layers+15+62)*y(NCom*L_layers+15+67)+(1/2)*kg(2)*y(NCom*L_layers+15+52)*y(NCom*L_layers+15+67)+(1/2)*kg(3)*y(NCom*L_layers+15+50)*y(NCom*L_layers+15+67);
%CI8
Pr(NCom*L_layers+15+60)=-kg(15)*y(NCom*L_layers+15+60)*y(NCom*L_layers+15+63)-kg(16)*y(NCom*L_layers+15+60)*y(NCom*L_layers+15+67)-kg(17)*y(NCom*L_layers+15+60)+(1/4)*kg(1)*y(NCom*L_layers+15+62)*y(NCom*L_layers+15+67);
%CI9
Pr(NCom*L_layers+15+61)=-kg(18)*y(NCom*L_layers+15+61)*y(NCom*L_layers+15+63)-kg(19)*y(NCom*L_layers+15+61)*y(NCom*L_layers+15+67)-kg(20)*y(NCom*L_layers+15+61)+(1/2)*kg(4)*y(NCom*L_layers+15+49)*y(NCom*L_layers+15+67);
%Geranyl acetone
Pr(NCom*L_layers+15+62)=-kg(1)*y(NCom*L_layers+15+62)*y(NCom*L_layers+15+67);
%H2O
Pr(NCom*L_layers+15+63)=-kg(6)*y(NCom*L_layers+15+55)*y(NCom*L_layers+15+63)-kg(9)*y(NCom*L_layers+15+57)*y(NCom*L_layers+15+63)-kg(12)*y(NCom*L_layers+15+59)*y(NCom*L_layers+15+63)-kg(15)*y(NCom*L_layers+15+60)*y(NCom*L_layers+15+63)-kg(18)*y(NCom*L_layers+15+61)*y(NCom*L_layers+15+63)-kg(21)*y(NCom*L_layers+15+56)*y(NCom*L_layers+15+63)-kg(24)*y(NCom*L_layers+15+58)*y(NCom*L_layers+15+63);
%HK1
Pr(NCom*L_layers+15+64)=+1*kg(8)*y(NCom*L_layers+15+55);
%HK2
Pr(NCom*L_layers+15+65)=+(1/2)*kg(5)*y(NCom*L_layers+15+66)*y(NCom*L_layers+15+67)+1*kg(23)*y(NCom*L_layers+15+56)+1*kg(24)*y(NCom*L_layers+15+58)*y(NCom*L_layers+15+63)+1*kg(25)*y(NCom*L_layers+15+58)*y(NCom*L_layers+15+67);
%HK3
Pr(NCom*L_layers+15+66)=-kg(5)*y(NCom*L_layers+15+66)*y(NCom*L_layers+15+67)+1*kg(11)*y(NCom*L_layers+15+57);
%O3
Pr(NCom*L_layers+15+67)=-kg(1)*y(NCom*L_layers+15+62)*y(NCom*L_layers+15+67)-kg(2)*y(NCom*L_layers+15+52)*y(NCom*L_layers+15+67)-kg(3)*y(NCom*L_layers+15+50)*y(NCom*L_layers+15+67)-kg(4)*y(NCom*L_layers+15+49)*y(NCom*L_layers+15+67)-kg(5)*y(NCom*L_layers+15+66)*y(NCom*L_layers+15+67)-kg(7)*y(NCom*L_layers+15+55)*y(NCom*L_layers+15+67)-kg(10)*y(NCom*L_layers+15+57)*y(NCom*L_layers+15+67)-kg(13)*y(NCom*L_layers+15+59)*y(NCom*L_layers+15+67)-kg(16)*y(NCom*L_layers+15+60)*y(NCom*L_layers+15+67)-kg(19)*y(NCom*L_layers+15+61)*y(NCom*L_layers+15+67)-kg(22)*y(NCom*L_layers+15+56)*y(NCom*L_layers+15+67)-kg(25)*y(NCom*L_layers+15+58)*y(NCom*L_layers+15+67);
%acetone
Pr(NCom*L_layers+15+68)=+(1/4)*kg(1)*y(NCom*L_layers+15+62)*y(NCom*L_layers+15+67)+(1/2)*kg(2)*y(NCom*L_layers+15+52)*y(NCom*L_layers+15+67)+(1/2)*kg(5)*y(NCom*L_layers+15+66)*y(NCom*L_layers+15+67)+1*kg(6)*y(NCom*L_layers+15+55)*y(NCom*L_layers+15+63)+1*kg(7)*y(NCom*L_layers+15+55)*y(NCom*L_layers+15+67);
%1,4 butanedial
Pr(NCom*L_layers+15+69)=+(1/2)*kg(4)*y(NCom*L_layers+15+49)*y(NCom*L_layers+15+67)+1*kg(18)*y(NCom*L_layers+15+61)*y(NCom*L_layers+15+63)+1*kg(19)*y(NCom*L_layers+15+61)*y(NCom*L_layers+15+67);

%%%%%%%------------In the boundary layer ------------%%%%%%%
%4-MOD
Pr(NCom*L_layers-48+49)=-kg(4)*y(NCom*L_layers-48+49)*y(NCom*L_layers-48+67);
%4-MON
Pr(NCom*L_layers-48+50)=-kg(3)*y(NCom*L_layers-48+50)*y(NCom*L_layers-48+67)+(1/4)*kg(1)*y(NCom*L_layers-48+62)*y(NCom*L_layers-48+67)+1*kg(15)*y(NCom*L_layers-48+60)*y(NCom*L_layers-48+63)+1*kg(16)*y(NCom*L_layers-48+60)*y(NCom*L_layers-48+67);
%4-OPA
Pr(NCom*L_layers-48+51)=+(1/4)*kg(1)*y(NCom*L_layers-48+62)*y(NCom*L_layers-48+67)+(1/2)*kg(2)*y(NCom*L_layers-48+52)*y(NCom*L_layers-48+67)+2*(1/2)*kg(3)*y(NCom*L_layers-48+50)*y(NCom*L_layers-48+67)+(1/2)*kg(4)*y(NCom*L_layers-48+49)*y(NCom*L_layers-48+67)+1*kg(12)*y(NCom*L_layers-48+59)*y(NCom*L_layers-48+63)+1*kg(13)*y(NCom*L_layers-48+59)*y(NCom*L_layers-48+67)+1*kg(21)*y(NCom*L_layers-48+56)*y(NCom*L_layers-48+63)+1*kg(22)*y(NCom*L_layers-48+56)*y(NCom*L_layers-48+67);
%6-MHO
Pr(NCom*L_layers-48+52)=-kg(2)*y(NCom*L_layers-48+52)*y(NCom*L_layers-48+67)+(1/4)*kg(1)*y(NCom*L_layers-48+62)*y(NCom*L_layers-48+67)+1*kg(9)*y(NCom*L_layers-48+57)*y(NCom*L_layers-48+63)+1*kg(10)*y(NCom*L_layers-48+57)*y(NCom*L_layers-48+67);
%CA1
Pr(NCom*L_layers-48+53)=+1*kg(14)*y(NCom*L_layers-48+59);
%CA2
Pr(NCom*L_layers-48+54)=+1*kg(20)*y(NCom*L_layers-48+61);
%CI1
Pr(NCom*L_layers-48+55)=-kg(6)*y(NCom*L_layers-48+55)*y(NCom*L_layers-48+63)-kg(7)*y(NCom*L_layers-48+55)*y(NCom*L_layers-48+67)-kg(8)*y(NCom*L_layers-48+55)+(1/4)*kg(1)*y(NCom*L_layers-48+62)*y(NCom*L_layers-48+67)+(1/2)*kg(2)*y(NCom*L_layers-48+52)*y(NCom*L_layers-48+67)+(1/2)*kg(5)*y(NCom*L_layers-48+66)*y(NCom*L_layers-48+67);
%CI12
Pr(NCom*L_layers-48+56)=-kg(21)*y(NCom*L_layers-48+56)*y(NCom*L_layers-48+63)-kg(22)*y(NCom*L_layers-48+56)*y(NCom*L_layers-48+67)-kg(23)*y(NCom*L_layers-48+56)+(1/2)*kg(3)*y(NCom*L_layers-48+50)*y(NCom*L_layers-48+67)+(1/2)*kg(4)*y(NCom*L_layers-48+49)*y(NCom*L_layers-48+67);
%CI2
Pr(NCom*L_layers-48+57)=-kg(9)*y(NCom*L_layers-48+57)*y(NCom*L_layers-48+63)-kg(10)*y(NCom*L_layers-48+57)*y(NCom*L_layers-48+67)-kg(11)*y(NCom*L_layers-48+57)+(1/4)*kg(1)*y(NCom*L_layers-48+62)*y(NCom*L_layers-48+67);
%CI20
Pr(NCom*L_layers-48+58)=-kg(24)*y(NCom*L_layers-48+58)*y(NCom*L_layers-48+63)-kg(25)*y(NCom*L_layers-48+58)*y(NCom*L_layers-48+67)-kg(26)*y(NCom*L_layers-48+58)+(1/2)*kg(5)*y(NCom*L_layers-48+66)*y(NCom*L_layers-48+67);
%CI7
Pr(NCom*L_layers-48+59)=-kg(12)*y(NCom*L_layers-48+59)*y(NCom*L_layers-48+63)-kg(13)*y(NCom*L_layers-48+59)*y(NCom*L_layers-48+67)-kg(14)*y(NCom*L_layers-48+59)+(1/4)*kg(1)*y(NCom*L_layers-48+62)*y(NCom*L_layers-48+67)+(1/2)*kg(2)*y(NCom*L_layers-48+52)*y(NCom*L_layers-48+67)+(1/2)*kg(3)*y(NCom*L_layers-48+50)*y(NCom*L_layers-48+67);
%CI8
Pr(NCom*L_layers-48+60)=-kg(15)*y(NCom*L_layers-48+60)*y(NCom*L_layers-48+63)-kg(16)*y(NCom*L_layers-48+60)*y(NCom*L_layers-48+67)-kg(17)*y(NCom*L_layers-48+60)+(1/4)*kg(1)*y(NCom*L_layers-48+62)*y(NCom*L_layers-48+67);
%CI9
Pr(NCom*L_layers-48+61)=-kg(18)*y(NCom*L_layers-48+61)*y(NCom*L_layers-48+63)-kg(19)*y(NCom*L_layers-48+61)*y(NCom*L_layers-48+67)-kg(20)*y(NCom*L_layers-48+61)+(1/2)*kg(4)*y(NCom*L_layers-48+49)*y(NCom*L_layers-48+67);
%Geranyl acetone
Pr(NCom*L_layers-48+62)=-kg(1)*y(NCom*L_layers-48+62)*y(NCom*L_layers-48+67);
%H2O
Pr(NCom*L_layers-48+63)=-kg(6)*y(NCom*L_layers-48+55)*y(NCom*L_layers-48+63)-kg(9)*y(NCom*L_layers-48+57)*y(NCom*L_layers-48+63)-kg(12)*y(NCom*L_layers-48+59)*y(NCom*L_layers-48+63)-kg(15)*y(NCom*L_layers-48+60)*y(NCom*L_layers-48+63)-kg(18)*y(NCom*L_layers-48+61)*y(NCom*L_layers-48+63)-kg(21)*y(NCom*L_layers-48+56)*y(NCom*L_layers-48+63)-kg(24)*y(NCom*L_layers-48+58)*y(NCom*L_layers-48+63);
%HK1
Pr(NCom*L_layers-48+64)=+1*kg(8)*y(NCom*L_layers-48+55);
%HK2
Pr(NCom*L_layers-48+65)=+(1/2)*kg(5)*y(NCom*L_layers-48+66)*y(NCom*L_layers-48+67)+1*kg(23)*y(NCom*L_layers-48+56)+1*kg(24)*y(NCom*L_layers-48+58)*y(NCom*L_layers-48+63)+1*kg(25)*y(NCom*L_layers-48+58)*y(NCom*L_layers-48+67);
%HK3
Pr(NCom*L_layers-48+66)=-kg(5)*y(NCom*L_layers-48+66)*y(NCom*L_layers-48+67)+1*kg(11)*y(NCom*L_layers-48+57);
%O3
Pr(NCom*L_layers-48+67)=-kg(1)*y(NCom*L_layers-48+62)*y(NCom*L_layers-48+67)-kg(2)*y(NCom*L_layers-48+52)*y(NCom*L_layers-48+67)-kg(3)*y(NCom*L_layers-48+50)*y(NCom*L_layers-48+67)-kg(4)*y(NCom*L_layers-48+49)*y(NCom*L_layers-48+67)-kg(5)*y(NCom*L_layers-48+66)*y(NCom*L_layers-48+67)-kg(7)*y(NCom*L_layers-48+55)*y(NCom*L_layers-48+67)-kg(10)*y(NCom*L_layers-48+57)*y(NCom*L_layers-48+67)-kg(13)*y(NCom*L_layers-48+59)*y(NCom*L_layers-48+67)-kg(16)*y(NCom*L_layers-48+60)*y(NCom*L_layers-48+67)-kg(19)*y(NCom*L_layers-48+61)*y(NCom*L_layers-48+67)-kg(22)*y(NCom*L_layers-48+56)*y(NCom*L_layers-48+67)-kg(25)*y(NCom*L_layers-48+58)*y(NCom*L_layers-48+67);
%acetone
Pr(NCom*L_layers-48+68)=+(1/4)*kg(1)*y(NCom*L_layers-48+62)*y(NCom*L_layers-48+67)+(1/2)*kg(2)*y(NCom*L_layers-48+52)*y(NCom*L_layers-48+67)+(1/2)*kg(5)*y(NCom*L_layers-48+66)*y(NCom*L_layers-48+67)+1*kg(6)*y(NCom*L_layers-48+55)*y(NCom*L_layers-48+63)+1*kg(7)*y(NCom*L_layers-48+55)*y(NCom*L_layers-48+67);
%1,4 butanedial
Pr(NCom*L_layers-48+69)=+(1/2)*kg(4)*y(NCom*L_layers-48+49)*y(NCom*L_layers-48+67)+1*kg(18)*y(NCom*L_layers-48+61)*y(NCom*L_layers-48+63)+1*kg(19)*y(NCom*L_layers-48+61)*y(NCom*L_layers-48+67);


%%%%%%%------------In the gas phase gap ------------%%%%%%%
%4-MOD
Pr(NCom*L_layers-6+49)=-kg(4)*y(NCom*L_layers-6+49)*y(NCom*L_layers-6+67);
%4-MON
Pr(NCom*L_layers-6+50)=-kg(3)*y(NCom*L_layers-6+50)*y(NCom*L_layers-6+67)+(1/4)*kg(1)*y(NCom*L_layers-6+62)*y(NCom*L_layers-6+67)+1*kg(15)*y(NCom*L_layers-6+60)*y(NCom*L_layers-6+63)+1*kg(16)*y(NCom*L_layers-6+60)*y(NCom*L_layers-6+67);
%4-OPA
Pr(NCom*L_layers-6+51)=+(1/4)*kg(1)*y(NCom*L_layers-6+62)*y(NCom*L_layers-6+67)+(1/2)*kg(2)*y(NCom*L_layers-6+52)*y(NCom*L_layers-6+67)+2*(1/2)*kg(3)*y(NCom*L_layers-6+50)*y(NCom*L_layers-6+67)+(1/2)*kg(4)*y(NCom*L_layers-6+49)*y(NCom*L_layers-6+67)+1*kg(12)*y(NCom*L_layers-6+59)*y(NCom*L_layers-6+63)+1*kg(13)*y(NCom*L_layers-6+59)*y(NCom*L_layers-6+67)+1*kg(21)*y(NCom*L_layers-6+56)*y(NCom*L_layers-6+63)+1*kg(22)*y(NCom*L_layers-6+56)*y(NCom*L_layers-6+67);
%6-MHO
Pr(NCom*L_layers-6+52)=-kg(2)*y(NCom*L_layers-6+52)*y(NCom*L_layers-6+67)+(1/4)*kg(1)*y(NCom*L_layers-6+62)*y(NCom*L_layers-6+67)+1*kg(9)*y(NCom*L_layers-6+57)*y(NCom*L_layers-6+63)+1*kg(10)*y(NCom*L_layers-6+57)*y(NCom*L_layers-6+67);
%CA1
Pr(NCom*L_layers-6+53)=+1*kg(14)*y(NCom*L_layers-6+59);
%CA2
Pr(NCom*L_layers-6+54)=+1*kg(20)*y(NCom*L_layers-6+61);
%CI1
Pr(NCom*L_layers-6+55)=-kg(6)*y(NCom*L_layers-6+55)*y(NCom*L_layers-6+63)-kg(7)*y(NCom*L_layers-6+55)*y(NCom*L_layers-6+67)-kg(8)*y(NCom*L_layers-6+55)+(1/4)*kg(1)*y(NCom*L_layers-6+62)*y(NCom*L_layers-6+67)+(1/2)*kg(2)*y(NCom*L_layers-6+52)*y(NCom*L_layers-6+67)+(1/2)*kg(5)*y(NCom*L_layers-6+66)*y(NCom*L_layers-6+67);
%CI12
Pr(NCom*L_layers-6+56)=-kg(21)*y(NCom*L_layers-6+56)*y(NCom*L_layers-6+63)-kg(22)*y(NCom*L_layers-6+56)*y(NCom*L_layers-6+67)-kg(23)*y(NCom*L_layers-6+56)+(1/2)*kg(3)*y(NCom*L_layers-6+50)*y(NCom*L_layers-6+67)+(1/2)*kg(4)*y(NCom*L_layers-6+49)*y(NCom*L_layers-6+67);
%CI2
Pr(NCom*L_layers-6+57)=-kg(9)*y(NCom*L_layers-6+57)*y(NCom*L_layers-6+63)-kg(10)*y(NCom*L_layers-6+57)*y(NCom*L_layers-6+67)-kg(11)*y(NCom*L_layers-6+57)+(1/4)*kg(1)*y(NCom*L_layers-6+62)*y(NCom*L_layers-6+67);
%CI20
Pr(NCom*L_layers-6+58)=-kg(24)*y(NCom*L_layers-6+58)*y(NCom*L_layers-6+63)-kg(25)*y(NCom*L_layers-6+58)*y(NCom*L_layers-6+67)-kg(26)*y(NCom*L_layers-6+58)+(1/2)*kg(5)*y(NCom*L_layers-6+66)*y(NCom*L_layers-6+67);
%CI7
Pr(NCom*L_layers-6+59)=-kg(12)*y(NCom*L_layers-6+59)*y(NCom*L_layers-6+63)-kg(13)*y(NCom*L_layers-6+59)*y(NCom*L_layers-6+67)-kg(14)*y(NCom*L_layers-6+59)+(1/4)*kg(1)*y(NCom*L_layers-6+62)*y(NCom*L_layers-6+67)+(1/2)*kg(2)*y(NCom*L_layers-6+52)*y(NCom*L_layers-6+67)+(1/2)*kg(3)*y(NCom*L_layers-6+50)*y(NCom*L_layers-6+67);
%CI8
Pr(NCom*L_layers-6+60)=-kg(15)*y(NCom*L_layers-6+60)*y(NCom*L_layers-6+63)-kg(16)*y(NCom*L_layers-6+60)*y(NCom*L_layers-6+67)-kg(17)*y(NCom*L_layers-6+60)+(1/4)*kg(1)*y(NCom*L_layers-6+62)*y(NCom*L_layers-6+67);
%CI9
Pr(NCom*L_layers-6+61)=-kg(18)*y(NCom*L_layers-6+61)*y(NCom*L_layers-6+63)-kg(19)*y(NCom*L_layers-6+61)*y(NCom*L_layers-6+67)-kg(20)*y(NCom*L_layers-6+61)+(1/2)*kg(4)*y(NCom*L_layers-6+49)*y(NCom*L_layers-6+67);
%Geranyl acetone
Pr(NCom*L_layers-6+62)=-kg(1)*y(NCom*L_layers-6+62)*y(NCom*L_layers-6+67);
%H20
Pr(NCom*L_layers-6+63)=-kg(6)*y(NCom*L_layers-6+55)*y(NCom*L_layers-6+63)-kg(9)*y(NCom*L_layers-6+57)*y(NCom*L_layers-6+63)-kg(12)*y(NCom*L_layers-6+59)*y(NCom*L_layers-6+63)-kg(15)*y(NCom*L_layers-6+60)*y(NCom*L_layers-6+63)-kg(18)*y(NCom*L_layers-6+61)*y(NCom*L_layers-6+63)-kg(21)*y(NCom*L_layers-6+56)*y(NCom*L_layers-6+63)-kg(24)*y(NCom*L_layers-6+58)*y(NCom*L_layers-6+63);
%HK1
Pr(NCom*L_layers-6+64)=+1*kg(8)*y(NCom*L_layers-6+55);
%HK2
Pr(NCom*L_layers-6+65)=+(1/2)*kg(5)*y(NCom*L_layers-6+66)*y(NCom*L_layers-6+67)+1*kg(23)*y(NCom*L_layers-6+56)+1*kg(24)*y(NCom*L_layers-6+58)*y(NCom*L_layers-6+63)+1*kg(25)*y(NCom*L_layers-6+58)*y(NCom*L_layers-6+67);
%HK3
Pr(NCom*L_layers-6+66)=-kg(5)*y(NCom*L_layers-6+66)*y(NCom*L_layers-6+67)+1*kg(11)*y(NCom*L_layers-6+57);
%ozone
Pr(NCom*L_layers-6+67)=-kg(1)*y(NCom*L_layers-6+62)*y(NCom*L_layers-6+67)-kg(2)*y(NCom*L_layers-6+52)*y(NCom*L_layers-6+67)-kg(3)*y(NCom*L_layers-6+50)*y(NCom*L_layers-6+67)-kg(4)*y(NCom*L_layers-6+49)*y(NCom*L_layers-6+67)-kg(5)*y(NCom*L_layers-6+66)*y(NCom*L_layers-6+67)-kg(7)*y(NCom*L_layers-6+55)*y(NCom*L_layers-6+67)-kg(10)*y(NCom*L_layers-6+57)*y(NCom*L_layers-6+67)-kg(13)*y(NCom*L_layers-6+59)*y(NCom*L_layers-6+67)-kg(16)*y(NCom*L_layers-6+60)*y(NCom*L_layers-6+67)-kg(19)*y(NCom*L_layers-6+61)*y(NCom*L_layers-6+67)-kg(22)*y(NCom*L_layers-6+56)*y(NCom*L_layers-6+67)-kg(25)*y(NCom*L_layers-6+58)*y(NCom*L_layers-6+67);
%acetone
Pr(NCom*L_layers-6+68)=+(1/4)*kg(1)*y(NCom*L_layers-6+62)*y(NCom*L_layers-6+67)+(1/2)*kg(2)*y(NCom*L_layers-6+52)*y(NCom*L_layers-6+67)+(1/2)*kg(5)*y(NCom*L_layers-6+66)*y(NCom*L_layers-6+67)+1*kg(6)*y(NCom*L_layers-6+55)*y(NCom*L_layers-6+63)+1*kg(7)*y(NCom*L_layers-6+55)*y(NCom*L_layers-6+67);
%1,4 butanedial
Pr(NCom*L_layers-6+69)=+(1/2)*kg(4)*y(NCom*L_layers-6+49)*y(NCom*L_layers-6+67)+1*kg(18)*y(NCom*L_layers-6+61)*y(NCom*L_layers-6+63)+1*kg(19)*y(NCom*L_layers-6+61)*y(NCom*L_layers-6+67);

%%%%%%%------------In the clothing condensed phase ------------%%%%%%%
for m=1:L_layers
    %Total CI concentration (cm-3)
    allCI(m)=y(NCom*(m-1)+9)+y(NCom*(m-1)+10)+y(NCom*(m-1)+11)+y(NCom*(m-1)+12)+y(NCom*(m-1)+13)+y(NCom*(m-1)+14)+y(NCom*(m-1)+15)+y(NCom*(m-1)+16)+y(NCom*(m-1)+17);
    %Total carbonyl concentration (cm-3)
    allcarbonyl(m)=2*y(NCom*(m-1)+1)+2*y(NCom*(m-1)+2)+2*y(NCom*(m-1)+3)+y(NCom*(m-1)+4)+y(NCom*(m-1)+6)+y(NCom*(m-1)+7)+y(NCom*(m-1)+20)+y(NCom*(m-1)+22)+2*y(NCom*(m-1)+23)+y(NCom*(m-1)+24)+y(NCom*(m-1)+25)+2*y(NCom*(m-1)+28)+2*y(NCom*(m-1)+29)+2*y(NCom*(m-1)+30)+2*y(NCom*(m-1)+31)+y(NCom*(m-1)+34)+y(NCom*(m-1)+35)+y(NCom*(m-1)+36)+y(NCom*(m-1)+38)+y(NCom*(m-1)+39)+y(NCom*(m-1)+40)+y(NCom*(m-1)+41)+y(NCom*(m-1)+43)+y(NCom*(m-1)+44)+y(NCom*(m-1)+45)+y(NCom*(m-1)+46)+y(NCom*(m-1)+47)+y(NCom*(m-1)+48);
%4-MOD
Pr(NCom*(m-1)+1)=-kbr(6)*y(NCom*(m-1)+1)*y(NCom*(m-1)+26)-kbr(54)*y(NCom*(m-1)+1)*allCI(m)+(1/6)*ratio_s*kbr(4)*y(NCom*(m-1)+45)*y(NCom*(m-1)+26)+(1/4)*ratio_s*kbr(7)*y(NCom*(m-1)+28)*y(NCom*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*(m-1)+43)*y(NCom*(m-1)+26)+2*(1/4)*ratio_s*kbr(9)*y(NCom*(m-1)+29)*y(NCom*(m-1)+26)+(1/6)*ratio_s*kbr(10)*y(NCom*(m-1)+30)*y(NCom*(m-1)+26);
%4-MON
Pr(NCom*(m-1)+2)=-kbr(5)*y(NCom*(m-1)+2)*y(NCom*(m-1)+26)-kbr(53)*y(NCom*(m-1)+2)*allCI(m)+(1/4)*ratio_s*kbr(3)*y(NCom*(m-1)+20)*y(NCom*(m-1)+26)+(1/4)*ratio_p*kbr(7)*y(NCom*(m-1)+28)*y(NCom*(m-1)+26)+(1/6)*ratio_p*kbr(10)*y(NCom*(m-1)+30)*y(NCom*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26)+(1/4)*ratio_p*kbr(12)*y(NCom*(m-1)+31)*y(NCom*(m-1)+26)+1*kbr(28)*y(NCom*(m-1)+11)*y(NCom*(m-1)+21)+1*kbr(29)*y(NCom*(m-1)+11)*y(NCom*(m-1)+26);
%4-OPA
Pr(NCom*(m-1)+3)=+(1/2)*ratio_s*kbr(2)*y(NCom*(m-1)+4)*y(NCom*(m-1)+26)+(1/4)*ratio_s*kbr(3)*y(NCom*(m-1)+20)*y(NCom*(m-1)+26)+2*(1/2)*(ratio_p/2+ratio_s/2)*kbr(5)*y(NCom*(m-1)+2)*y(NCom*(m-1)+26)+(1/2)*ratio_p*kbr(6)*y(NCom*(m-1)+1)*y(NCom*(m-1)+26)+(1/4)*ratio_p*kbr(7)*y(NCom*(m-1)+28)*y(NCom*(m-1)+26)+(1/8)*ratio_p*kbr(8)*y(NCom*(m-1)+43)*y(NCom*(m-1)+26)+2*(1/4)*ratio_s*kbr(9)*y(NCom*(m-1)+29)*y(NCom*(m-1)+26)+2*(1/6)*ratio_p*kbr(10)*y(NCom*(m-1)+30)*y(NCom*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26)+(1/4)*ratio_p*kbr(12)*y(NCom*(m-1)+31)*y(NCom*(m-1)+26)+1*kbr(20)*y(NCom*(m-1)+10)*y(NCom*(m-1)+21)+1*kbr(21)*y(NCom*(m-1)+10)*y(NCom*(m-1)+26)+(1/2)*ratio_s*kbr(69)*y(NCom*(m-1)+38)*y(NCom*(m-1)+26)+(1/2)*ratio_p*kbr(71)*y(NCom*(m-1)+40)*y(NCom*(m-1)+26)+(1/2)*ratio_p*kbr(72)*y(NCom*(m-1)+41)*y(NCom*(m-1)+26);
%6-MHO
Pr(NCom*(m-1)+4)=-kbr(2)*y(NCom*(m-1)+4)*y(NCom*(m-1)+26)-kbr(48)*y(NCom*(m-1)+4)*allCI(m)+(1/6)*ratio_p*kbr(1)*y(NCom*(m-1)+42)*y(NCom*(m-1)+26)+(1/4)*ratio_p*kbr(3)*y(NCom*(m-1)+20)*y(NCom*(m-1)+26)+(1/6)*ratio_p*kbr(4)*y(NCom*(m-1)+45)*y(NCom*(m-1)+26)+(1/8)*ratio_p*kbr(8)*y(NCom*(m-1)+43)*y(NCom*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26)+(1/4)*ratio_p*kbr(14)*y(NCom*(m-1)+25)*y(NCom*(m-1)+26)+(1/6)*ratio_p*kbr(15)*y(NCom*(m-1)+8)*y(NCom*(m-1)+26)+1*kbr(24)*y(NCom*(m-1)+12)*y(NCom*(m-1)+21)+1*kbr(25)*y(NCom*(m-1)+12)*y(NCom*(m-1)+26)+(1/4)*ratio_p*kbr(73)*y(NCom*(m-1)+32)*y(NCom*(m-1)+26)+(1/6)*ratio_p*kbr(74)*y(NCom*(m-1)+33)*y(NCom*(m-1)+26);
%Acids
Pr(NCom*(m-1)+5)=-kbr(90)*y(NCom*(m-1)+9)*y(NCom*(m-1)+5)-kbr(91)*y(NCom*(m-1)+10)*y(NCom*(m-1)+5)-kbr(92)*y(NCom*(m-1)+12)*y(NCom*(m-1)+5)-kbr(93)*y(NCom*(m-1)+11)*y(NCom*(m-1)+5)-kbr(94)*y(NCom*(m-1)+13)*y(NCom*(m-1)+5)-kbr(95)*y(NCom*(m-1)+14)*y(NCom*(m-1)+5)-kbr(96)*y(NCom*(m-1)+15)*y(NCom*(m-1)+5)-kbr(97)*y(NCom*(m-1)+16)*y(NCom*(m-1)+5)-kbr(98)*y(NCom*(m-1)+18)*y(NCom*(m-1)+5)-kbr(99)*y(NCom*(m-1)+19)*y(NCom*(m-1)+5)-kbr(105)*y(NCom*(m-1)+5)*allCI(m)+kbr(103)*y(NCom*(m-1)+17);
%CA1
Pr(NCom*(m-1)+6)=-kbr(59)*y(NCom*(m-1)+6)*allCI(m);
%CA2
Pr(NCom*(m-1)+7)=-kbr(60)*y(NCom*(m-1)+7)*allCI(m)+(1/6)*ratio_s*kbr(15)*y(NCom*(m-1)+8)*y(NCom*(m-1)+26);
%CA9
Pr(NCom*(m-1)+8)=-kbr(15)*y(NCom*(m-1)+8)*y(NCom*(m-1)+26)+1*kbr(38)*y(NCom*(m-1)+14);
%CI1
Pr(NCom*(m-1)+9)=-kbr(16)*y(NCom*(m-1)+9)*y(NCom*(m-1)+21)-kbr(17)*y(NCom*(m-1)+9)*y(NCom*(m-1)+26)-kbr(18)*y(NCom*(m-1)+9)-kbr(19)*y(NCom*(m-1)+9)*allcarbonyl(m)-kbr(90)*y(NCom*(m-1)+9)*y(NCom*(m-1)+5)+(1/6)*ratio_s*kbr(1)*y(NCom*(m-1)+42)*y(NCom*(m-1)+26)+(1/2)*ratio_s*kbr(2)*y(NCom*(m-1)+4)*y(NCom*(m-1)+26)+(1/4)*ratio_s*kbr(3)*y(NCom*(m-1)+20)*y(NCom*(m-1)+26)+(1/6)*ratio_s*kbr(4)*y(NCom*(m-1)+45)*y(NCom*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*(m-1)+43)*y(NCom*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26)+(1/2)*ratio_s*kbr(13)*y(NCom*(m-1)+24)*y(NCom*(m-1)+26)+(1/4)*ratio_s*kbr(14)*y(NCom*(m-1)+25)*y(NCom*(m-1)+26)+(1/6)*ratio_s*kbr(15)*y(NCom*(m-1)+8)*y(NCom*(m-1)+26)+(1/2)*ratio_s*kbr(68)*y(NCom*(m-1)+37)*y(NCom*(m-1)+26)+(1/4)*ratio_s*kbr(73)*y(NCom*(m-1)+32)*y(NCom*(m-1)+26)+(1/6)*ratio_s*kbr(74)*y(NCom*(m-1)+33)*y(NCom*(m-1)+26);
%CI12
Pr(NCom*(m-1)+10)=-kbr(20)*y(NCom*(m-1)+10)*y(NCom*(m-1)+21)-kbr(21)*y(NCom*(m-1)+10)*y(NCom*(m-1)+26)-kbr(22)*y(NCom*(m-1)+10)-kbr(23)*y(NCom*(m-1)+10)*allcarbonyl(m)-kbr(91)*y(NCom*(m-1)+10)*y(NCom*(m-1)+5)+(1/2)*ratio_s*kbr(5)*y(NCom*(m-1)+2)*y(NCom*(m-1)+26)+(1/2)*ratio_s*kbr(6)*y(NCom*(m-1)+1)*y(NCom*(m-1)+26)+(1/4)*ratio_s*kbr(7)*y(NCom*(m-1)+28)*y(NCom*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*(m-1)+43)*y(NCom*(m-1)+26)+2*(1/4)*ratio_s*kbr(9)*y(NCom*(m-1)+29)*y(NCom*(m-1)+26)+2*(1/6)*ratio_s*kbr(10)*y(NCom*(m-1)+30)*y(NCom*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26)+(1/4)*ratio_s*kbr(12)*y(NCom*(m-1)+31)*y(NCom*(m-1)+26)+(1/2)*ratio_s*kbr(71)*y(NCom*(m-1)+40)*y(NCom*(m-1)+26)+(1/2)*ratio_s*kbr(72)*y(NCom*(m-1)+41)*y(NCom*(m-1)+26);
%CI16
Pr(NCom*(m-1)+11)=-kbr(28)*y(NCom*(m-1)+11)*y(NCom*(m-1)+21)-kbr(29)*y(NCom*(m-1)+11)*y(NCom*(m-1)+26)-kbr(30)*y(NCom*(m-1)+11)-kbr(31)*y(NCom*(m-1)+11)*allcarbonyl(m)-kbr(93)*y(NCom*(m-1)+11)*y(NCom*(m-1)+5)+(1/4)*ratio_s*kbr(7)*y(NCom*(m-1)+28)*y(NCom*(m-1)+26)+(1/6)*ratio_s*kbr(10)*y(NCom*(m-1)+30)*y(NCom*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26)+(1/4)*ratio_s*kbr(12)*y(NCom*(m-1)+31)*y(NCom*(m-1)+26);
%CI2
Pr(NCom*(m-1)+12)=-kbr(24)*y(NCom*(m-1)+12)*y(NCom*(m-1)+21)-kbr(25)*y(NCom*(m-1)+12)*y(NCom*(m-1)+26)-kbr(26)*y(NCom*(m-1)+12)-kbr(27)*y(NCom*(m-1)+12)*allcarbonyl(m)-kbr(92)*y(NCom*(m-1)+12)*y(NCom*(m-1)+5)+(1/6)*ratio_s*kbr(1)*y(NCom*(m-1)+42)*y(NCom*(m-1)+26)+(1/4)*ratio_s*kbr(3)*y(NCom*(m-1)+20)*y(NCom*(m-1)+26)+(1/6)*ratio_s*kbr(4)*y(NCom*(m-1)+45)*y(NCom*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*(m-1)+43)*y(NCom*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26)+(1/4)*ratio_s*kbr(14)*y(NCom*(m-1)+25)*y(NCom*(m-1)+26)+(1/6)*ratio_s*kbr(15)*y(NCom*(m-1)+8)*y(NCom*(m-1)+26)+(1/4)*ratio_s*kbr(73)*y(NCom*(m-1)+32)*y(NCom*(m-1)+26)+(1/6)*ratio_s*kbr(74)*y(NCom*(m-1)+33)*y(NCom*(m-1)+26);
%CI3
Pr(NCom*(m-1)+13)=-kbr(32)*y(NCom*(m-1)+13)*y(NCom*(m-1)+21)-kbr(33)*y(NCom*(m-1)+13)*y(NCom*(m-1)+26)-kbr(34)*y(NCom*(m-1)+13)-kbr(35)*y(NCom*(m-1)+13)*allcarbonyl(m)-kbr(94)*y(NCom*(m-1)+13)*y(NCom*(m-1)+5)+(1/6)*ratio_s*kbr(1)*y(NCom*(m-1)+42)*y(NCom*(m-1)+26)+(1/6)*ratio_s*kbr(4)*y(NCom*(m-1)+45)*y(NCom*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*(m-1)+43)*y(NCom*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26)+(1/6)*ratio_s*kbr(15)*y(NCom*(m-1)+8)*y(NCom*(m-1)+26)+(1/6)*ratio_s*kbr(74)*y(NCom*(m-1)+33)*y(NCom*(m-1)+26);
%CI4
Pr(NCom*(m-1)+14)=-kbr(36)*y(NCom*(m-1)+14)*y(NCom*(m-1)+21)-kbr(37)*y(NCom*(m-1)+14)*y(NCom*(m-1)+26)-kbr(38)*y(NCom*(m-1)+14)-kbr(39)*y(NCom*(m-1)+14)*allcarbonyl(m)-kbr(95)*y(NCom*(m-1)+14)*y(NCom*(m-1)+5)+(1/6)*ratio_p*kbr(1)*y(NCom*(m-1)+42)*y(NCom*(m-1)+26)+(1/8)*ratio_p*kbr(8)*y(NCom*(m-1)+43)*y(NCom*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26);
%CI5
Pr(NCom*(m-1)+15)=-kbr(40)*y(NCom*(m-1)+15)*y(NCom*(m-1)+21)-kbr(41)*y(NCom*(m-1)+15)*y(NCom*(m-1)+26)-kbr(42)*y(NCom*(m-1)+15)-kbr(43)*y(NCom*(m-1)+15)*allcarbonyl(m)-kbr(96)*y(NCom*(m-1)+15)*y(NCom*(m-1)+5)+(1/6)*ratio_p*kbr(1)*y(NCom*(m-1)+42)*y(NCom*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26);
%CI6
Pr(NCom*(m-1)+16)=-kbr(44)*y(NCom*(m-1)+16)*y(NCom*(m-1)+21)-kbr(45)*y(NCom*(m-1)+16)*y(NCom*(m-1)+26)-kbr(46)*y(NCom*(m-1)+16)-kbr(47)*y(NCom*(m-1)+16)*allcarbonyl(m)-kbr(97)*y(NCom*(m-1)+16)*y(NCom*(m-1)+5)+(1/6)*ratio_p*kbr(1)*y(NCom*(m-1)+42)*y(NCom*(m-1)+26);
%CIDB
Pr(NCom*(m-1)+17)=-kbr(101)*y(NCom*(m-1)+17)*y(NCom*(m-1)+21)-kbr(102)*y(NCom*(m-1)+17)*y(NCom*(m-1)+26)-kbr(103)*y(NCom*(m-1)+17)-kbr(104)*y(NCom*(m-1)+17)*allcarbonyl(m)+1*kbr(100)*y(NCom*(m-1)+27)*y(NCom*(m-1)+26);
%CISOorHP2
Pr(NCom*(m-1)+18)=-kbr(75)*y(NCom*(m-1)+18)*y(NCom*(m-1)+21)-kbr(76)*y(NCom*(m-1)+18)*y(NCom*(m-1)+26)-kbr(77)*y(NCom*(m-1)+18)-kbr(78)*y(NCom*(m-1)+18)*allcarbonyl(m)-kbr(98)*y(NCom*(m-1)+18)*y(NCom*(m-1)+5)+(1/2)*kbr(69)*y(NCom*(m-1)+38)*y(NCom*(m-1)+26)+(1/2)*kbr(70)*y(NCom*(m-1)+39)*y(NCom*(m-1)+26);
%CISOorHP5
Pr(NCom*(m-1)+19)=-kbr(79)*y(NCom*(m-1)+19)*y(NCom*(m-1)+21)-kbr(80)*y(NCom*(m-1)+19)*y(NCom*(m-1)+26)-kbr(81)*y(NCom*(m-1)+19)-kbr(82)*y(NCom*(m-1)+19)*allcarbonyl(m)-kbr(99)*y(NCom*(m-1)+19)*y(NCom*(m-1)+5);
%Geranyl acetone
Pr(NCom*(m-1)+20)=-kbr(3)*y(NCom*(m-1)+20)*y(NCom*(m-1)+26)-kbr(49)*y(NCom*(m-1)+20)*allCI(m)+(1/6)*kbr(1)*y(NCom*(m-1)+42)*y(NCom*(m-1)+26)+(1/6)*kbr(4)*y(NCom*(m-1)+45)*y(NCom*(m-1)+26)+(1/8)*kbr(8)*y(NCom*(m-1)+43)*y(NCom*(m-1)+26)+(1/10)*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26)+(1/6)*kbr(15)*y(NCom*(m-1)+8)*y(NCom*(m-1)+26)+1*kbr(32)*y(NCom*(m-1)+13)*y(NCom*(m-1)+21)+1*kbr(33)*y(NCom*(m-1)+13)*y(NCom*(m-1)+26)+(1/6)*kbr(74)*y(NCom*(m-1)+33)*y(NCom*(m-1)+26);
%H2O
Pr(NCom*(m-1)+21)=-kbr(16)*y(NCom*(m-1)+9)*y(NCom*(m-1)+21)-kbr(20)*y(NCom*(m-1)+10)*y(NCom*(m-1)+21)-kbr(24)*y(NCom*(m-1)+12)*y(NCom*(m-1)+21)-kbr(28)*y(NCom*(m-1)+11)*y(NCom*(m-1)+21)-kbr(32)*y(NCom*(m-1)+13)*y(NCom*(m-1)+21)-kbr(36)*y(NCom*(m-1)+14)*y(NCom*(m-1)+21)-kbr(40)*y(NCom*(m-1)+15)*y(NCom*(m-1)+21)-kbr(44)*y(NCom*(m-1)+16)*y(NCom*(m-1)+21)-kbr(75)*y(NCom*(m-1)+18)*y(NCom*(m-1)+21)-kbr(79)*y(NCom*(m-1)+19)*y(NCom*(m-1)+21)-kbr(101)*y(NCom*(m-1)+17)*y(NCom*(m-1)+21);
%HK1
Pr(NCom*(m-1)+22)=+1*kbr(18)*y(NCom*(m-1)+9);
%HK2
Pr(NCom*(m-1)+23)=-kbr(64)*y(NCom*(m-1)+23)*allCI(m)+(1/2)*ratio_s*kbr(13)*y(NCom*(m-1)+24)*y(NCom*(m-1)+26)+(1/4)*ratio_s*kbr(14)*y(NCom*(m-1)+25)*y(NCom*(m-1)+26)+1*kbr(22)*y(NCom*(m-1)+10);
%HK3
Pr(NCom*(m-1)+24)=-kbr(13)*y(NCom*(m-1)+24)*y(NCom*(m-1)+26)-kbr(65)*y(NCom*(m-1)+24)*allCI(m)+1*kbr(26)*y(NCom*(m-1)+12);
%HK5
Pr(NCom*(m-1)+25)=-kbr(14)*y(NCom*(m-1)+25)*y(NCom*(m-1)+26)-kbr(67)*y(NCom*(m-1)+25)*allCI(m)+1*kbr(34)*y(NCom*(m-1)+13);
%O3
Pr(NCom*(m-1)+26)=-kbr(1)*y(NCom*(m-1)+42)*y(NCom*(m-1)+26)-kbr(2)*y(NCom*(m-1)+4)*y(NCom*(m-1)+26)-kbr(3)*y(NCom*(m-1)+20)*y(NCom*(m-1)+26)-kbr(4)*y(NCom*(m-1)+45)*y(NCom*(m-1)+26)-kbr(5)*y(NCom*(m-1)+2)*y(NCom*(m-1)+26)-kbr(6)*y(NCom*(m-1)+1)*y(NCom*(m-1)+26)-kbr(7)*y(NCom*(m-1)+28)*y(NCom*(m-1)+26)-kbr(8)*y(NCom*(m-1)+43)*y(NCom*(m-1)+26)-kbr(9)*y(NCom*(m-1)+29)*y(NCom*(m-1)+26)-kbr(10)*y(NCom*(m-1)+30)*y(NCom*(m-1)+26)-kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26)-kbr(12)*y(NCom*(m-1)+31)*y(NCom*(m-1)+26)-kbr(13)*y(NCom*(m-1)+24)*y(NCom*(m-1)+26)-kbr(14)*y(NCom*(m-1)+25)*y(NCom*(m-1)+26)-kbr(15)*y(NCom*(m-1)+8)*y(NCom*(m-1)+26)-kbr(17)*y(NCom*(m-1)+9)*y(NCom*(m-1)+26)-kbr(21)*y(NCom*(m-1)+10)*y(NCom*(m-1)+26)-kbr(25)*y(NCom*(m-1)+12)*y(NCom*(m-1)+26)-kbr(29)*y(NCom*(m-1)+11)*y(NCom*(m-1)+26)-kbr(33)*y(NCom*(m-1)+13)*y(NCom*(m-1)+26)-kbr(37)*y(NCom*(m-1)+14)*y(NCom*(m-1)+26)-kbr(41)*y(NCom*(m-1)+15)*y(NCom*(m-1)+26)-kbr(45)*y(NCom*(m-1)+16)*y(NCom*(m-1)+26)-kbr(68)*y(NCom*(m-1)+37)*y(NCom*(m-1)+26)-kbr(69)*y(NCom*(m-1)+38)*y(NCom*(m-1)+26)-kbr(70)*y(NCom*(m-1)+39)*y(NCom*(m-1)+26)-kbr(71)*y(NCom*(m-1)+40)*y(NCom*(m-1)+26)-kbr(72)*y(NCom*(m-1)+41)*y(NCom*(m-1)+26)-kbr(73)*y(NCom*(m-1)+32)*y(NCom*(m-1)+26)-kbr(74)*y(NCom*(m-1)+33)*y(NCom*(m-1)+26)-kbr(76)*y(NCom*(m-1)+18)*y(NCom*(m-1)+26)-kbr(80)*y(NCom*(m-1)+19)*y(NCom*(m-1)+26)-kbr(100)*y(NCom*(m-1)+27)*y(NCom*(m-1)+26)-kbr(102)*y(NCom*(m-1)+17)*y(NCom*(m-1)+26);
%Other double bondas
Pr(NCom*(m-1)+27)=-kbr(100)*y(NCom*(m-1)+27)*y(NCom*(m-1)+26);
%Product A
Pr(NCom*(m-1)+28)=-kbr(7)*y(NCom*(m-1)+28)*y(NCom*(m-1)+26)-kbr(55)*y(NCom*(m-1)+28)*allCI(m)+(1/6)*ratio_s*kbr(4)*y(NCom*(m-1)+45)*y(NCom*(m-1)+26)+(1/6)*ratio_s*kbr(10)*y(NCom*(m-1)+30)*y(NCom*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26)+(1/4)*ratio_s*kbr(12)*y(NCom*(m-1)+31)*y(NCom*(m-1)+26);
%Product B
Pr(NCom*(m-1)+29)=-kbr(9)*y(NCom*(m-1)+29)*y(NCom*(m-1)+26)-kbr(56)*y(NCom*(m-1)+29)*allCI(m)+(1/8)*ratio_s*kbr(8)*y(NCom*(m-1)+43)*y(NCom*(m-1)+26)+(1/6)*ratio_s*kbr(10)*y(NCom*(m-1)+30)*y(NCom*(m-1)+26);
%Product C
Pr(NCom*(m-1)+30)=-kbr(10)*y(NCom*(m-1)+30)*y(NCom*(m-1)+26)-kbr(57)*y(NCom*(m-1)+30)*allCI(m)+(1/8)*ratio_s*kbr(8)*y(NCom*(m-1)+43)*y(NCom*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26)+(1/4)*ratio_s*kbr(12)*y(NCom*(m-1)+31)*y(NCom*(m-1)+26);
%Product D
Pr(NCom*(m-1)+31)=-kbr(12)*y(NCom*(m-1)+31)*y(NCom*(m-1)+26)-kbr(58)*y(NCom*(m-1)+31)*allCI(m)+(1/10)*ratio_s*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26);
%SO or HP10
Pr(NCom*(m-1)+32)=-kbr(73)*y(NCom*(m-1)+32)*y(NCom*(m-1)+26)+1*kbr(35)*y(NCom*(m-1)+13)*allcarbonyl(m)+1*kbr(49)*y(NCom*(m-1)+20)*allCI(m)+1*kbr(94)*y(NCom*(m-1)+13)*y(NCom*(m-1)+5);
%SO or HP14
Pr(NCom*(m-1)+33)=-kbr(74)*y(NCom*(m-1)+33)*y(NCom*(m-1)+26)+1*kbr(39)*y(NCom*(m-1)+14)*allcarbonyl(m)+1*kbr(50)*y(NCom*(m-1)+45)*allCI(m)+1*kbr(95)*y(NCom*(m-1)+14)*y(NCom*(m-1)+5);
%SO or HP2
Pr(NCom*(m-1)+34)=-kbr(83)*y(NCom*(m-1)+34)*allCI(m)+(1/2)*ratio_p*kbr(69)*y(NCom*(m-1)+38)*y(NCom*(m-1)+26)+(1/2)*ratio_p*kbr(70)*y(NCom*(m-1)+39)*y(NCom*(m-1)+26)+1*kbr(75)*y(NCom*(m-1)+18)*y(NCom*(m-1)+21)+1*kbr(76)*y(NCom*(m-1)+18)*y(NCom*(m-1)+26);
%SO or HP3
Pr(NCom*(m-1)+35)=-kbr(84)*y(NCom*(m-1)+35)*allCI(m)+(1/2)*ratio_s*kbr(71)*y(NCom*(m-1)+40)*y(NCom*(m-1)+26)+(1/6)*ratio_s*kbr(74)*y(NCom*(m-1)+33)*y(NCom*(m-1)+26);
%SO or HP4
Pr(NCom*(m-1)+36)=-kbr(85)*y(NCom*(m-1)+36)*allCI(m)+1*kbr(23)*y(NCom*(m-1)+10)*allcarbonyl(m)+(1/2)*ratio_s*kbr(68)*y(NCom*(m-1)+37)*y(NCom*(m-1)+26)+(1/2)*ratio_s*kbr(72)*y(NCom*(m-1)+41)*y(NCom*(m-1)+26)+(1/4)*ratio_s*kbr(73)*y(NCom*(m-1)+32)*y(NCom*(m-1)+26)+1*kbr(91)*y(NCom*(m-1)+10)*y(NCom*(m-1)+5);
%SO or HP5
Pr(NCom*(m-1)+37)=-kbr(68)*y(NCom*(m-1)+37)*y(NCom*(m-1)+26)+1*kbr(27)*y(NCom*(m-1)+12)*allcarbonyl(m)+1*kbr(48)*y(NCom*(m-1)+4)*allCI(m)+1*kbr(92)*y(NCom*(m-1)+12)*y(NCom*(m-1)+5);
%SO or HP6
Pr(NCom*(m-1)+38)=-kbr(69)*y(NCom*(m-1)+38)*y(NCom*(m-1)+26)-kbr(86)*y(NCom*(m-1)+38)*allCI(m)+(1/2)*kbr(53)*y(NCom*(m-1)+2)*allCI(m)+1*kbr(79)*y(NCom*(m-1)+19)*y(NCom*(m-1)+21)+1*kbr(80)*y(NCom*(m-1)+19)*y(NCom*(m-1)+26);
%SO or HP7
Pr(NCom*(m-1)+39)=-kbr(70)*y(NCom*(m-1)+39)*y(NCom*(m-1)+26)-kbr(87)*y(NCom*(m-1)+39)*allCI(m)+(1/2)*kbr(54)*y(NCom*(m-1)+1)*allCI(m);
%SO or HP8
Pr(NCom*(m-1)+40)=-kbr(71)*y(NCom*(m-1)+40)*y(NCom*(m-1)+26)-kbr(88)*y(NCom*(m-1)+40)*allCI(m)+(1/2)*kbr(54)*y(NCom*(m-1)+1)*allCI(m)+(1/6)*ratio_s*kbr(74)*y(NCom*(m-1)+33)*y(NCom*(m-1)+26);
%SO or HP9
Pr(NCom*(m-1)+41)=-kbr(72)*y(NCom*(m-1)+41)*y(NCom*(m-1)+26)-kbr(89)*y(NCom*(m-1)+41)*allCI(m)+1*kbr(31)*y(NCom*(m-1)+11)*allcarbonyl(m)+(1/2)*kbr(53)*y(NCom*(m-1)+2)*allCI(m)+(1/4)*ratio_s*kbr(73)*y(NCom*(m-1)+32)*y(NCom*(m-1)+26)+1*kbr(93)*y(NCom*(m-1)+11)*y(NCom*(m-1)+5);
%Squalene
Pr(NCom*(m-1)+42)=-kbr(1)*y(NCom*(m-1)+42)*y(NCom*(m-1)+26);
%TOP
Pr(NCom*(m-1)+43)=-kbr(8)*y(NCom*(m-1)+43)*y(NCom*(m-1)+26)-kbr(51)*y(NCom*(m-1)+43)*allCI(m)+(1/6)*ratio_s*kbr(1)*y(NCom*(m-1)+42)*y(NCom*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26)+1*kbr(40)*y(NCom*(m-1)+15)*y(NCom*(m-1)+21)+1*kbr(41)*y(NCom*(m-1)+15)*y(NCom*(m-1)+26);
%TOT
Pr(NCom*(m-1)+44)=-kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26)-kbr(52)*y(NCom*(m-1)+44)*allCI(m)+(1/6)*ratio_s*kbr(1)*y(NCom*(m-1)+42)*y(NCom*(m-1)+26)+1*kbr(44)*y(NCom*(m-1)+16)*y(NCom*(m-1)+21)+1*kbr(45)*y(NCom*(m-1)+16)*y(NCom*(m-1)+26);
%TTT
Pr(NCom*(m-1)+45)=-kbr(4)*y(NCom*(m-1)+45)*y(NCom*(m-1)+26)-kbr(50)*y(NCom*(m-1)+45)*allCI(m)+(1/6)*ratio_s*kbr(1)*y(NCom*(m-1)+42)*y(NCom*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*(m-1)+43)*y(NCom*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26)+1*kbr(36)*y(NCom*(m-1)+14)*y(NCom*(m-1)+21)+1*kbr(37)*y(NCom*(m-1)+14)*y(NCom*(m-1)+26);
%acetone
Pr(NCom*(m-1)+46)=+(1/6)*ratio_p*kbr(1)*y(NCom*(m-1)+42)*y(NCom*(m-1)+26)+(1/2)*ratio_p*kbr(2)*y(NCom*(m-1)+4)*y(NCom*(m-1)+26)+(1/4)*ratio_p*kbr(3)*y(NCom*(m-1)+20)*y(NCom*(m-1)+26)+(1/6)*ratio_p*kbr(4)*y(NCom*(m-1)+45)*y(NCom*(m-1)+26)+(1/8)*ratio_p*kbr(8)*y(NCom*(m-1)+43)*y(NCom*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*(m-1)+44)*y(NCom*(m-1)+26)+(1/2)*ratio_p*kbr(13)*y(NCom*(m-1)+24)*y(NCom*(m-1)+26)+(1/4)*ratio_p*kbr(14)*y(NCom*(m-1)+25)*y(NCom*(m-1)+26)+(1/6)*ratio_p*kbr(15)*y(NCom*(m-1)+8)*y(NCom*(m-1)+26)+1*kbr(16)*y(NCom*(m-1)+9)*y(NCom*(m-1)+21)+1*kbr(17)*y(NCom*(m-1)+9)*y(NCom*(m-1)+26)+(1/2)*ratio_p*kbr(68)*y(NCom*(m-1)+37)*y(NCom*(m-1)+26)+(1/4)*ratio_p*kbr(73)*y(NCom*(m-1)+32)*y(NCom*(m-1)+26)+(1/6)*ratio_p*kbr(74)*y(NCom*(m-1)+33)*y(NCom*(m-1)+26);
%1,4 butanedial
Pr(NCom*(m-1)+47)=+(1/6)*ratio_s*kbr(4)*y(NCom*(m-1)+45)*y(NCom*(m-1)+26)+(1/2)*ratio_s*kbr(6)*y(NCom*(m-1)+1)*y(NCom*(m-1)+26)+(1/4)*ratio_s*kbr(7)*y(NCom*(m-1)+28)*y(NCom*(m-1)+26)+(1/2)*ratio_s*kbr(70)*y(NCom*(m-1)+39)*y(NCom*(m-1)+26);
%Carbonyl products
Pr(NCom*(m-1)+48)=kbr(101)*y(NCom*(m-1)+17)*y(NCom*(m-1)+21)+kbr(102)*y(NCom*(m-1)+17)*y(NCom*(m-1)+26)-kbr(106)*y(NCom*(m-1)+48)*allCI(m);

%%%%%%%------------In the clothing gas phase ------------%%%%%%%
%4-MOD
Pr(NCom*(m-1)+49)=-kg(4)*y(NCom*(m-1)+49)*y(NCom*(m-1)+67);
%4_MON
Pr(NCom*(m-1)+50)=-kg(3)*y(NCom*(m-1)+50)*y(NCom*(m-1)+67)+(1/4)*kg(1)*y(NCom*(m-1)+62)*y(NCom*(m-1)+67)+1*kg(15)*y(NCom*(m-1)+60)*y(NCom*(m-1)+63)+1*kg(16)*y(NCom*(m-1)+60)*y(NCom*(m-1)+67);
%4-OPA
Pr(NCom*(m-1)+51)=+(1/4)*kg(1)*y(NCom*(m-1)+62)*y(NCom*(m-1)+67)+(1/2)*kg(2)*y(NCom*(m-1)+52)*y(NCom*(m-1)+67)+2*(1/2)*kg(3)*y(NCom*(m-1)+50)*y(NCom*(m-1)+67)+(1/2)*kg(4)*y(NCom*(m-1)+49)*y(NCom*(m-1)+67)+1*kg(12)*y(NCom*(m-1)+59)*y(NCom*(m-1)+63)+1*kg(13)*y(NCom*(m-1)+59)*y(NCom*(m-1)+67)+1*kg(21)*y(NCom*(m-1)+56)*y(NCom*(m-1)+63)+1*kg(22)*y(NCom*(m-1)+56)*y(NCom*(m-1)+67);
%6-MHO
Pr(NCom*(m-1)+52)=-kg(2)*y(NCom*(m-1)+52)*y(NCom*(m-1)+67)+(1/4)*kg(1)*y(NCom*(m-1)+62)*y(NCom*(m-1)+67)+1*kg(9)*y(NCom*(m-1)+57)*y(NCom*(m-1)+63)+1*kg(10)*y(NCom*(m-1)+57)*y(NCom*(m-1)+67);
%CA1
Pr(NCom*(m-1)+53)=+1*kg(14)*y(NCom*(m-1)+59);
%CA2
Pr(NCom*(m-1)+54)=+1*kg(20)*y(NCom*(m-1)+61);
%CI1
Pr(NCom*(m-1)+55)=-kg(6)*y(NCom*(m-1)+55)*y(NCom*(m-1)+63)-kg(7)*y(NCom*(m-1)+55)*y(NCom*(m-1)+67)-kg(8)*y(NCom*(m-1)+55)+(1/4)*kg(1)*y(NCom*(m-1)+62)*y(NCom*(m-1)+67)+(1/2)*kg(2)*y(NCom*(m-1)+52)*y(NCom*(m-1)+67)+(1/2)*kg(5)*y(NCom*(m-1)+66)*y(NCom*(m-1)+67);
%CI12
Pr(NCom*(m-1)+56)=-kg(21)*y(NCom*(m-1)+56)*y(NCom*(m-1)+63)-kg(22)*y(NCom*(m-1)+56)*y(NCom*(m-1)+67)-kg(23)*y(NCom*(m-1)+56)+(1/2)*kg(3)*y(NCom*(m-1)+50)*y(NCom*(m-1)+67)+(1/2)*kg(4)*y(NCom*(m-1)+49)*y(NCom*(m-1)+67);
%CI2
Pr(NCom*(m-1)+57)=-kg(9)*y(NCom*(m-1)+57)*y(NCom*(m-1)+63)-kg(10)*y(NCom*(m-1)+57)*y(NCom*(m-1)+67)-kg(11)*y(NCom*(m-1)+57)+(1/4)*kg(1)*y(NCom*(m-1)+62)*y(NCom*(m-1)+67);
%CI20
Pr(NCom*(m-1)+58)=-kg(24)*y(NCom*(m-1)+58)*y(NCom*(m-1)+63)-kg(25)*y(NCom*(m-1)+58)*y(NCom*(m-1)+67)-kg(26)*y(NCom*(m-1)+58)+(1/2)*kg(5)*y(NCom*(m-1)+66)*y(NCom*(m-1)+67);
%CI7
Pr(NCom*(m-1)+59)=-kg(12)*y(NCom*(m-1)+59)*y(NCom*(m-1)+63)-kg(13)*y(NCom*(m-1)+59)*y(NCom*(m-1)+67)-kg(14)*y(NCom*(m-1)+59)+(1/4)*kg(1)*y(NCom*(m-1)+62)*y(NCom*(m-1)+67)+(1/2)*kg(2)*y(NCom*(m-1)+52)*y(NCom*(m-1)+67)+(1/2)*kg(3)*y(NCom*(m-1)+50)*y(NCom*(m-1)+67);
%CI8
Pr(NCom*(m-1)+60)=-kg(15)*y(NCom*(m-1)+60)*y(NCom*(m-1)+63)-kg(16)*y(NCom*(m-1)+60)*y(NCom*(m-1)+67)-kg(17)*y(NCom*(m-1)+60)+(1/4)*kg(1)*y(NCom*(m-1)+62)*y(NCom*(m-1)+67);
%CI9
Pr(NCom*(m-1)+61)=-kg(18)*y(NCom*(m-1)+61)*y(NCom*(m-1)+63)-kg(19)*y(NCom*(m-1)+61)*y(NCom*(m-1)+67)-kg(20)*y(NCom*(m-1)+61)+(1/2)*kg(4)*y(NCom*(m-1)+49)*y(NCom*(m-1)+67);
%Geranyl acetone
Pr(NCom*(m-1)+62)=-kg(1)*y(NCom*(m-1)+62)*y(NCom*(m-1)+67);
%H20
Pr(NCom*(m-1)+63)=-kg(6)*y(NCom*(m-1)+55)*y(NCom*(m-1)+63)-kg(9)*y(NCom*(m-1)+57)*y(NCom*(m-1)+63)-kg(12)*y(NCom*(m-1)+59)*y(NCom*(m-1)+63)-kg(15)*y(NCom*(m-1)+60)*y(NCom*(m-1)+63)-kg(18)*y(NCom*(m-1)+61)*y(NCom*(m-1)+63)-kg(21)*y(NCom*(m-1)+56)*y(NCom*(m-1)+63)-kg(24)*y(NCom*(m-1)+58)*y(NCom*(m-1)+63);
%HK1
Pr(NCom*(m-1)+64)=+1*kg(8)*y(NCom*(m-1)+55);
%HK2
Pr(NCom*(m-1)+65)=+(1/2)*kg(5)*y(NCom*(m-1)+66)*y(NCom*(m-1)+67)+1*kg(23)*y(NCom*(m-1)+56)+1*kg(24)*y(NCom*(m-1)+58)*y(NCom*(m-1)+63)+1*kg(25)*y(NCom*(m-1)+58)*y(NCom*(m-1)+67);
%HK3
Pr(NCom*(m-1)+66)=-kg(5)*y(NCom*(m-1)+66)*y(NCom*(m-1)+67)+1*kg(11)*y(NCom*(m-1)+57);
%O3
Pr(NCom*(m-1)+67)=-kg(1)*y(NCom*(m-1)+62)*y(NCom*(m-1)+67)-kg(2)*y(NCom*(m-1)+52)*y(NCom*(m-1)+67)-kg(3)*y(NCom*(m-1)+50)*y(NCom*(m-1)+67)-kg(4)*y(NCom*(m-1)+49)*y(NCom*(m-1)+67)-kg(5)*y(NCom*(m-1)+66)*y(NCom*(m-1)+67)-kg(7)*y(NCom*(m-1)+55)*y(NCom*(m-1)+67)-kg(10)*y(NCom*(m-1)+57)*y(NCom*(m-1)+67)-kg(13)*y(NCom*(m-1)+59)*y(NCom*(m-1)+67)-kg(16)*y(NCom*(m-1)+60)*y(NCom*(m-1)+67)-kg(19)*y(NCom*(m-1)+61)*y(NCom*(m-1)+67)-kg(22)*y(NCom*(m-1)+56)*y(NCom*(m-1)+67)-kg(25)*y(NCom*(m-1)+58)*y(NCom*(m-1)+67);
%acetone
Pr(NCom*(m-1)+68)=+(1/4)*kg(1)*y(NCom*(m-1)+62)*y(NCom*(m-1)+67)+(1/2)*kg(2)*y(NCom*(m-1)+52)*y(NCom*(m-1)+67)+(1/2)*kg(5)*y(NCom*(m-1)+66)*y(NCom*(m-1)+67)+1*kg(6)*y(NCom*(m-1)+55)*y(NCom*(m-1)+63)+1*kg(7)*y(NCom*(m-1)+55)*y(NCom*(m-1)+67);
%1,4 butanedial
Pr(NCom*(m-1)+69)=+(1/2)*kg(4)*y(NCom*(m-1)+49)*y(NCom*(m-1)+67)+1*kg(18)*y(NCom*(m-1)+61)*y(NCom*(m-1)+63)+1*kg(19)*y(NCom*(m-1)+61)*y(NCom*(m-1)+67);
end

%%%%%%%------------In the skin oil ------------%%%%%%%
for m=1:oil_layers
    %Total CI concentration (cm-3)
    allCI(L_layers+m)=y(NCom*L_layers+105+48*(m-1)+9)+y(NCom*L_layers+105+48*(m-1)+10)+y(NCom*L_layers+105+48*(m-1)+11)+y(NCom*L_layers+105+48*(m-1)+12)+y(NCom*L_layers+105+48*(m-1)+13)+y(NCom*L_layers+105+48*(m-1)+14)+y(NCom*L_layers+105+48*(m-1)+15)+y(NCom*L_layers+105+48*(m-1)+16)+y(NCom*L_layers+105+48*(m-1)+17);
    %Total carbonyl concentration (cm-3)
    allcarbonyl(L_layers+m)=2*y(NCom*L_layers+105+48*(m-1)+1)+2*y(NCom*L_layers+105+48*(m-1)+2)+2*y(NCom*L_layers+105+48*(m-1)+3)+y(NCom*L_layers+105+48*(m-1)+4)+y(NCom*L_layers+105+48*(m-1)+6)+y(NCom*L_layers+105+48*(m-1)+7)+y(NCom*L_layers+105+48*(m-1)+20)+y(NCom*L_layers+105+48*(m-1)+22)+2*y(NCom*L_layers+105+48*(m-1)+23)+y(NCom*L_layers+105+48*(m-1)+24)+y(NCom*L_layers+105+48*(m-1)+25)+2*y(NCom*L_layers+105+48*(m-1)+28)+2*y(NCom*L_layers+105+48*(m-1)+29)+2*y(NCom*L_layers+105+48*(m-1)+30)+2*y(NCom*L_layers+105+48*(m-1)+31)+y(NCom*L_layers+105+48*(m-1)+34)+y(NCom*L_layers+105+48*(m-1)+35)+y(NCom*L_layers+105+48*(m-1)+36)+y(NCom*L_layers+105+48*(m-1)+38)+y(NCom*L_layers+105+48*(m-1)+39)+y(NCom*L_layers+105+48*(m-1)+40)+y(NCom*L_layers+105+48*(m-1)+41)+y(NCom*L_layers+105+48*(m-1)+43)+y(NCom*L_layers+105+48*(m-1)+44)+y(NCom*L_layers+105+48*(m-1)+45)+y(NCom*L_layers+105+48*(m-1)+46)+y(NCom*L_layers+105+48*(m-1)+47)+y(NCom*L_layers+105+48*(m-1)+48);

%4-MOD
Pr(NCom*L_layers+105+48*(m-1)+1)=-kbr(6)*y(NCom*L_layers+105+48*(m-1)+1)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(54)*y(NCom*L_layers+105+48*(m-1)+1)*allCI(L_layers+m)+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+48*(m-1)+45)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_s*kbr(7)*y(NCom*L_layers+105+48*(m-1)+28)*y(NCom*L_layers+105+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+48*(m-1)+43)*y(NCom*L_layers+105+48*(m-1)+26)+2*(1/4)*ratio_s*kbr(9)*y(NCom*L_layers+105+48*(m-1)+29)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_s*kbr(10)*y(NCom*L_layers+105+48*(m-1)+30)*y(NCom*L_layers+105+48*(m-1)+26);
%4-MON
Pr(NCom*L_layers+105+48*(m-1)+2)=-kbr(5)*y(NCom*L_layers+105+48*(m-1)+2)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(53)*y(NCom*L_layers+105+48*(m-1)+2)*allCI(L_layers+m)+(1/4)*ratio_s*kbr(3)*y(NCom*L_layers+105+48*(m-1)+20)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_p*kbr(7)*y(NCom*L_layers+105+48*(m-1)+28)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_p*kbr(10)*y(NCom*L_layers+105+48*(m-1)+30)*y(NCom*L_layers+105+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_p*kbr(12)*y(NCom*L_layers+105+48*(m-1)+31)*y(NCom*L_layers+105+48*(m-1)+26)+1*kbr(28)*y(NCom*L_layers+105+48*(m-1)+11)*y(NCom*L_layers+105+48*(m-1)+21)+1*kbr(29)*y(NCom*L_layers+105+48*(m-1)+11)*y(NCom*L_layers+105+48*(m-1)+26);
%4-OPA
Pr(NCom*L_layers+105+48*(m-1)+3)=+(1/2)*ratio_s*kbr(2)*y(NCom*L_layers+105+48*(m-1)+4)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_s*kbr(3)*y(NCom*L_layers+105+48*(m-1)+20)*y(NCom*L_layers+105+48*(m-1)+26)+2*(1/2)*(ratio_p/2+ratio_s/2)*kbr(5)*y(NCom*L_layers+105+48*(m-1)+2)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_p*kbr(6)*y(NCom*L_layers+105+48*(m-1)+1)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_p*kbr(7)*y(NCom*L_layers+105+48*(m-1)+28)*y(NCom*L_layers+105+48*(m-1)+26)+(1/8)*ratio_p*kbr(8)*y(NCom*L_layers+105+48*(m-1)+43)*y(NCom*L_layers+105+48*(m-1)+26)+2*(1/4)*ratio_s*kbr(9)*y(NCom*L_layers+105+48*(m-1)+29)*y(NCom*L_layers+105+48*(m-1)+26)+2*(1/6)*ratio_p*kbr(10)*y(NCom*L_layers+105+48*(m-1)+30)*y(NCom*L_layers+105+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_p*kbr(12)*y(NCom*L_layers+105+48*(m-1)+31)*y(NCom*L_layers+105+48*(m-1)+26)+1*kbr(20)*y(NCom*L_layers+105+48*(m-1)+10)*y(NCom*L_layers+105+48*(m-1)+21)+1*kbr(21)*y(NCom*L_layers+105+48*(m-1)+10)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_s*kbr(69)*y(NCom*L_layers+105+48*(m-1)+38)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_p*kbr(71)*y(NCom*L_layers+105+48*(m-1)+40)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_p*kbr(72)*y(NCom*L_layers+105+48*(m-1)+41)*y(NCom*L_layers+105+48*(m-1)+26);
%6-MHO
Pr(NCom*L_layers+105+48*(m-1)+4)=-kbr(2)*y(NCom*L_layers+105+48*(m-1)+4)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(48)*y(NCom*L_layers+105+48*(m-1)+4)*allCI(L_layers+m)+(1/6)*ratio_p*kbr(1)*y(NCom*L_layers+105+48*(m-1)+42)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_p*kbr(3)*y(NCom*L_layers+105+48*(m-1)+20)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_p*kbr(4)*y(NCom*L_layers+105+48*(m-1)+45)*y(NCom*L_layers+105+48*(m-1)+26)+(1/8)*ratio_p*kbr(8)*y(NCom*L_layers+105+48*(m-1)+43)*y(NCom*L_layers+105+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_p*kbr(14)*y(NCom*L_layers+105+48*(m-1)+25)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_p*kbr(15)*y(NCom*L_layers+105+48*(m-1)+8)*y(NCom*L_layers+105+48*(m-1)+26)+1*kbr(24)*y(NCom*L_layers+105+48*(m-1)+12)*y(NCom*L_layers+105+48*(m-1)+21)+1*kbr(25)*y(NCom*L_layers+105+48*(m-1)+12)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_p*kbr(73)*y(NCom*L_layers+105+48*(m-1)+32)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_p*kbr(74)*y(NCom*L_layers+105+48*(m-1)+33)*y(NCom*L_layers+105+48*(m-1)+26);
%Acids
Pr(NCom*L_layers+105+48*(m-1)+5)=-kbr(90)*y(NCom*L_layers+105+48*(m-1)+9)*y(NCom*L_layers+105+48*(m-1)+5)-kbr(91)*y(NCom*L_layers+105+48*(m-1)+10)*y(NCom*L_layers+105+48*(m-1)+5)-kbr(92)*y(NCom*L_layers+105+48*(m-1)+12)*y(NCom*L_layers+105+48*(m-1)+5)-kbr(93)*y(NCom*L_layers+105+48*(m-1)+11)*y(NCom*L_layers+105+48*(m-1)+5)-kbr(94)*y(NCom*L_layers+105+48*(m-1)+13)*y(NCom*L_layers+105+48*(m-1)+5)-kbr(95)*y(NCom*L_layers+105+48*(m-1)+14)*y(NCom*L_layers+105+48*(m-1)+5)-kbr(96)*y(NCom*L_layers+105+48*(m-1)+15)*y(NCom*L_layers+105+48*(m-1)+5)-kbr(97)*y(NCom*L_layers+105+48*(m-1)+16)*y(NCom*L_layers+105+48*(m-1)+5)-kbr(98)*y(NCom*L_layers+105+48*(m-1)+18)*y(NCom*L_layers+105+48*(m-1)+5)-kbr(99)*y(NCom*L_layers+105+48*(m-1)+19)*y(NCom*L_layers+105+48*(m-1)+5)-kbr(105)*y(NCom*L_layers+105+48*(m-1)+5)*allCI(L_layers+m)+kbr(103)*y(NCom*L_layers+105+48*(m-1)+17);
%CA1
Pr(NCom*L_layers+105+48*(m-1)+6)=-kbr(59)*y(NCom*L_layers+105+48*(m-1)+6)*allCI(L_layers+m);
%CA2
Pr(NCom*L_layers+105+48*(m-1)+7)=-kbr(60)*y(NCom*L_layers+105+48*(m-1)+7)*allCI(L_layers+m)+(1/6)*ratio_s*kbr(15)*y(NCom*L_layers+105+48*(m-1)+8)*y(NCom*L_layers+105+48*(m-1)+26);
%CA9
Pr(NCom*L_layers+105+48*(m-1)+8)=-kbr(15)*y(NCom*L_layers+105+48*(m-1)+8)*y(NCom*L_layers+105+48*(m-1)+26)+1*kbr(38)*y(NCom*L_layers+105+48*(m-1)+14);
%CI1
Pr(NCom*L_layers+105+48*(m-1)+9)=-kbr(16)*y(NCom*L_layers+105+48*(m-1)+9)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(17)*y(NCom*L_layers+105+48*(m-1)+9)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(18)*y(NCom*L_layers+105+48*(m-1)+9)-kbr(19)*y(NCom*L_layers+105+48*(m-1)+9)*allcarbonyl(L_layers+m)-kbr(90)*y(NCom*L_layers+105+48*(m-1)+9)*y(NCom*L_layers+105+48*(m-1)+5)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+48*(m-1)+42)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_s*kbr(2)*y(NCom*L_layers+105+48*(m-1)+4)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_s*kbr(3)*y(NCom*L_layers+105+48*(m-1)+20)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+48*(m-1)+45)*y(NCom*L_layers+105+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+48*(m-1)+43)*y(NCom*L_layers+105+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_s*kbr(13)*y(NCom*L_layers+105+48*(m-1)+24)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_s*kbr(14)*y(NCom*L_layers+105+48*(m-1)+25)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_s*kbr(15)*y(NCom*L_layers+105+48*(m-1)+8)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_s*kbr(68)*y(NCom*L_layers+105+48*(m-1)+37)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_s*kbr(73)*y(NCom*L_layers+105+48*(m-1)+32)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_s*kbr(74)*y(NCom*L_layers+105+48*(m-1)+33)*y(NCom*L_layers+105+48*(m-1)+26);
%CI12
Pr(NCom*L_layers+105+48*(m-1)+10)=-kbr(20)*y(NCom*L_layers+105+48*(m-1)+10)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(21)*y(NCom*L_layers+105+48*(m-1)+10)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(22)*y(NCom*L_layers+105+48*(m-1)+10)-kbr(23)*y(NCom*L_layers+105+48*(m-1)+10)*allcarbonyl(L_layers+m)-kbr(91)*y(NCom*L_layers+105+48*(m-1)+10)*y(NCom*L_layers+105+48*(m-1)+5)+(1/2)*ratio_s*kbr(5)*y(NCom*L_layers+105+48*(m-1)+2)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_s*kbr(6)*y(NCom*L_layers+105+48*(m-1)+1)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_s*kbr(7)*y(NCom*L_layers+105+48*(m-1)+28)*y(NCom*L_layers+105+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+48*(m-1)+43)*y(NCom*L_layers+105+48*(m-1)+26)+2*(1/4)*ratio_s*kbr(9)*y(NCom*L_layers+105+48*(m-1)+29)*y(NCom*L_layers+105+48*(m-1)+26)+2*(1/6)*ratio_s*kbr(10)*y(NCom*L_layers+105+48*(m-1)+30)*y(NCom*L_layers+105+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_s*kbr(12)*y(NCom*L_layers+105+48*(m-1)+31)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_s*kbr(71)*y(NCom*L_layers+105+48*(m-1)+40)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_s*kbr(72)*y(NCom*L_layers+105+48*(m-1)+41)*y(NCom*L_layers+105+48*(m-1)+26);
%CI16
Pr(NCom*L_layers+105+48*(m-1)+11)=-kbr(28)*y(NCom*L_layers+105+48*(m-1)+11)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(29)*y(NCom*L_layers+105+48*(m-1)+11)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(30)*y(NCom*L_layers+105+48*(m-1)+11)-kbr(31)*y(NCom*L_layers+105+48*(m-1)+11)*allcarbonyl(L_layers+m)-kbr(93)*y(NCom*L_layers+105+48*(m-1)+11)*y(NCom*L_layers+105+48*(m-1)+5)+(1/4)*ratio_s*kbr(7)*y(NCom*L_layers+105+48*(m-1)+28)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_s*kbr(10)*y(NCom*L_layers+105+48*(m-1)+30)*y(NCom*L_layers+105+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_s*kbr(12)*y(NCom*L_layers+105+48*(m-1)+31)*y(NCom*L_layers+105+48*(m-1)+26);
%CI2
Pr(NCom*L_layers+105+48*(m-1)+12)=-kbr(24)*y(NCom*L_layers+105+48*(m-1)+12)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(25)*y(NCom*L_layers+105+48*(m-1)+12)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(26)*y(NCom*L_layers+105+48*(m-1)+12)-kbr(27)*y(NCom*L_layers+105+48*(m-1)+12)*allcarbonyl(L_layers+m)-kbr(92)*y(NCom*L_layers+105+48*(m-1)+12)*y(NCom*L_layers+105+48*(m-1)+5)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+48*(m-1)+42)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_s*kbr(3)*y(NCom*L_layers+105+48*(m-1)+20)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+48*(m-1)+45)*y(NCom*L_layers+105+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+48*(m-1)+43)*y(NCom*L_layers+105+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_s*kbr(14)*y(NCom*L_layers+105+48*(m-1)+25)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_s*kbr(15)*y(NCom*L_layers+105+48*(m-1)+8)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_s*kbr(73)*y(NCom*L_layers+105+48*(m-1)+32)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_s*kbr(74)*y(NCom*L_layers+105+48*(m-1)+33)*y(NCom*L_layers+105+48*(m-1)+26);
%CI3
Pr(NCom*L_layers+105+48*(m-1)+13)=-kbr(32)*y(NCom*L_layers+105+48*(m-1)+13)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(33)*y(NCom*L_layers+105+48*(m-1)+13)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(34)*y(NCom*L_layers+105+48*(m-1)+13)-kbr(35)*y(NCom*L_layers+105+48*(m-1)+13)*allcarbonyl(L_layers+m)-kbr(94)*y(NCom*L_layers+105+48*(m-1)+13)*y(NCom*L_layers+105+48*(m-1)+5)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+48*(m-1)+42)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+48*(m-1)+45)*y(NCom*L_layers+105+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+48*(m-1)+43)*y(NCom*L_layers+105+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_s*kbr(15)*y(NCom*L_layers+105+48*(m-1)+8)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_s*kbr(74)*y(NCom*L_layers+105+48*(m-1)+33)*y(NCom*L_layers+105+48*(m-1)+26);
%CI4
Pr(NCom*L_layers+105+48*(m-1)+14)=-kbr(36)*y(NCom*L_layers+105+48*(m-1)+14)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(37)*y(NCom*L_layers+105+48*(m-1)+14)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(38)*y(NCom*L_layers+105+48*(m-1)+14)-kbr(39)*y(NCom*L_layers+105+48*(m-1)+14)*allcarbonyl(L_layers+m)-kbr(95)*y(NCom*L_layers+105+48*(m-1)+14)*y(NCom*L_layers+105+48*(m-1)+5)+(1/6)*ratio_p*kbr(1)*y(NCom*L_layers+105+48*(m-1)+42)*y(NCom*L_layers+105+48*(m-1)+26)+(1/8)*ratio_p*kbr(8)*y(NCom*L_layers+105+48*(m-1)+43)*y(NCom*L_layers+105+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26);
%CI5
Pr(NCom*L_layers+105+48*(m-1)+15)=-kbr(40)*y(NCom*L_layers+105+48*(m-1)+15)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(41)*y(NCom*L_layers+105+48*(m-1)+15)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(42)*y(NCom*L_layers+105+48*(m-1)+15)-kbr(43)*y(NCom*L_layers+105+48*(m-1)+15)*allcarbonyl(L_layers+m)-kbr(96)*y(NCom*L_layers+105+48*(m-1)+15)*y(NCom*L_layers+105+48*(m-1)+5)+(1/6)*ratio_p*kbr(1)*y(NCom*L_layers+105+48*(m-1)+42)*y(NCom*L_layers+105+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26);
%CI6
Pr(NCom*L_layers+105+48*(m-1)+16)=-kbr(44)*y(NCom*L_layers+105+48*(m-1)+16)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(45)*y(NCom*L_layers+105+48*(m-1)+16)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(46)*y(NCom*L_layers+105+48*(m-1)+16)-kbr(47)*y(NCom*L_layers+105+48*(m-1)+16)*allcarbonyl(L_layers+m)-kbr(97)*y(NCom*L_layers+105+48*(m-1)+16)*y(NCom*L_layers+105+48*(m-1)+5)+(1/6)*ratio_p*kbr(1)*y(NCom*L_layers+105+48*(m-1)+42)*y(NCom*L_layers+105+48*(m-1)+26);
%CIDB
Pr(NCom*L_layers+105+48*(m-1)+17)=-kbr(101)*y(NCom*L_layers+105+48*(m-1)+17)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(102)*y(NCom*L_layers+105+48*(m-1)+17)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(103)*y(NCom*L_layers+105+48*(m-1)+17)-kbr(104)*y(NCom*L_layers+105+48*(m-1)+17)*allcarbonyl(L_layers+m)+1*kbr(100)*y(NCom*L_layers+105+48*(m-1)+27)*y(NCom*L_layers+105+48*(m-1)+26);
%CISOorHP2
Pr(NCom*L_layers+105+48*(m-1)+18)=-kbr(75)*y(NCom*L_layers+105+48*(m-1)+18)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(76)*y(NCom*L_layers+105+48*(m-1)+18)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(77)*y(NCom*L_layers+105+48*(m-1)+18)-kbr(78)*y(NCom*L_layers+105+48*(m-1)+18)*allcarbonyl(L_layers+m)-kbr(98)*y(NCom*L_layers+105+48*(m-1)+18)*y(NCom*L_layers+105+48*(m-1)+5)+(1/2)*kbr(69)*y(NCom*L_layers+105+48*(m-1)+38)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*kbr(70)*y(NCom*L_layers+105+48*(m-1)+39)*y(NCom*L_layers+105+48*(m-1)+26);
%CISOorHP5
Pr(NCom*L_layers+105+48*(m-1)+19)=-kbr(79)*y(NCom*L_layers+105+48*(m-1)+19)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(80)*y(NCom*L_layers+105+48*(m-1)+19)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(81)*y(NCom*L_layers+105+48*(m-1)+19)-kbr(82)*y(NCom*L_layers+105+48*(m-1)+19)*allcarbonyl(L_layers+m)-kbr(99)*y(NCom*L_layers+105+48*(m-1)+19)*y(NCom*L_layers+105+48*(m-1)+5);
%Geranyl acetone
Pr(NCom*L_layers+105+48*(m-1)+20)=-kbr(3)*y(NCom*L_layers+105+48*(m-1)+20)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(49)*y(NCom*L_layers+105+48*(m-1)+20)*allCI(L_layers+m)+(1/6)*kbr(1)*y(NCom*L_layers+105+48*(m-1)+42)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*kbr(4)*y(NCom*L_layers+105+48*(m-1)+45)*y(NCom*L_layers+105+48*(m-1)+26)+(1/8)*kbr(8)*y(NCom*L_layers+105+48*(m-1)+43)*y(NCom*L_layers+105+48*(m-1)+26)+(1/10)*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*kbr(15)*y(NCom*L_layers+105+48*(m-1)+8)*y(NCom*L_layers+105+48*(m-1)+26)+1*kbr(32)*y(NCom*L_layers+105+48*(m-1)+13)*y(NCom*L_layers+105+48*(m-1)+21)+1*kbr(33)*y(NCom*L_layers+105+48*(m-1)+13)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*kbr(74)*y(NCom*L_layers+105+48*(m-1)+33)*y(NCom*L_layers+105+48*(m-1)+26);
%H2O
Pr(NCom*L_layers+105+48*(m-1)+21)=-kbr(16)*y(NCom*L_layers+105+48*(m-1)+9)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(20)*y(NCom*L_layers+105+48*(m-1)+10)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(24)*y(NCom*L_layers+105+48*(m-1)+12)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(28)*y(NCom*L_layers+105+48*(m-1)+11)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(32)*y(NCom*L_layers+105+48*(m-1)+13)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(36)*y(NCom*L_layers+105+48*(m-1)+14)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(40)*y(NCom*L_layers+105+48*(m-1)+15)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(44)*y(NCom*L_layers+105+48*(m-1)+16)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(75)*y(NCom*L_layers+105+48*(m-1)+18)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(79)*y(NCom*L_layers+105+48*(m-1)+19)*y(NCom*L_layers+105+48*(m-1)+21)-kbr(101)*y(NCom*L_layers+105+48*(m-1)+17)*y(NCom*L_layers+105+48*(m-1)+21);
%HK1
Pr(NCom*L_layers+105+48*(m-1)+22)=+1*kbr(18)*y(NCom*L_layers+105+48*(m-1)+9);
%HK2
Pr(NCom*L_layers+105+48*(m-1)+23)=-kbr(64)*y(NCom*L_layers+105+48*(m-1)+23)*allCI(L_layers+m)+(1/2)*ratio_s*kbr(13)*y(NCom*L_layers+105+48*(m-1)+24)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_s*kbr(14)*y(NCom*L_layers+105+48*(m-1)+25)*y(NCom*L_layers+105+48*(m-1)+26)+1*kbr(22)*y(NCom*L_layers+105+48*(m-1)+10);
%HK3
Pr(NCom*L_layers+105+48*(m-1)+24)=-kbr(13)*y(NCom*L_layers+105+48*(m-1)+24)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(65)*y(NCom*L_layers+105+48*(m-1)+24)*allCI(L_layers+m)+1*kbr(26)*y(NCom*L_layers+105+48*(m-1)+12);
%HK5
Pr(NCom*L_layers+105+48*(m-1)+25)=-kbr(14)*y(NCom*L_layers+105+48*(m-1)+25)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(67)*y(NCom*L_layers+105+48*(m-1)+25)*allCI(L_layers+m)+1*kbr(34)*y(NCom*L_layers+105+48*(m-1)+13);
%O3
Pr(NCom*L_layers+105+48*(m-1)+26)=-kbr(1)*y(NCom*L_layers+105+48*(m-1)+42)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(2)*y(NCom*L_layers+105+48*(m-1)+4)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(3)*y(NCom*L_layers+105+48*(m-1)+20)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(4)*y(NCom*L_layers+105+48*(m-1)+45)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(5)*y(NCom*L_layers+105+48*(m-1)+2)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(6)*y(NCom*L_layers+105+48*(m-1)+1)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(7)*y(NCom*L_layers+105+48*(m-1)+28)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(8)*y(NCom*L_layers+105+48*(m-1)+43)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(9)*y(NCom*L_layers+105+48*(m-1)+29)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(10)*y(NCom*L_layers+105+48*(m-1)+30)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(12)*y(NCom*L_layers+105+48*(m-1)+31)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(13)*y(NCom*L_layers+105+48*(m-1)+24)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(14)*y(NCom*L_layers+105+48*(m-1)+25)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(15)*y(NCom*L_layers+105+48*(m-1)+8)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(17)*y(NCom*L_layers+105+48*(m-1)+9)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(21)*y(NCom*L_layers+105+48*(m-1)+10)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(25)*y(NCom*L_layers+105+48*(m-1)+12)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(29)*y(NCom*L_layers+105+48*(m-1)+11)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(33)*y(NCom*L_layers+105+48*(m-1)+13)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(37)*y(NCom*L_layers+105+48*(m-1)+14)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(41)*y(NCom*L_layers+105+48*(m-1)+15)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(45)*y(NCom*L_layers+105+48*(m-1)+16)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(68)*y(NCom*L_layers+105+48*(m-1)+37)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(69)*y(NCom*L_layers+105+48*(m-1)+38)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(70)*y(NCom*L_layers+105+48*(m-1)+39)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(71)*y(NCom*L_layers+105+48*(m-1)+40)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(72)*y(NCom*L_layers+105+48*(m-1)+41)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(73)*y(NCom*L_layers+105+48*(m-1)+32)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(74)*y(NCom*L_layers+105+48*(m-1)+33)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(76)*y(NCom*L_layers+105+48*(m-1)+18)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(80)*y(NCom*L_layers+105+48*(m-1)+19)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(100)*y(NCom*L_layers+105+48*(m-1)+27)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(102)*y(NCom*L_layers+105+48*(m-1)+17)*y(NCom*L_layers+105+48*(m-1)+26);
%Other double bonds
Pr(NCom*L_layers+105+48*(m-1)+27)=-kbr(100)*y(NCom*L_layers+105+48*(m-1)+27)*y(NCom*L_layers+105+48*(m-1)+26);
%Product A
Pr(NCom*L_layers+105+48*(m-1)+28)=-kbr(7)*y(NCom*L_layers+105+48*(m-1)+28)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(55)*y(NCom*L_layers+105+48*(m-1)+28)*allCI(L_layers+m)+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+48*(m-1)+45)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_s*kbr(10)*y(NCom*L_layers+105+48*(m-1)+30)*y(NCom*L_layers+105+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_s*kbr(12)*y(NCom*L_layers+105+48*(m-1)+31)*y(NCom*L_layers+105+48*(m-1)+26);
%Product B
Pr(NCom*L_layers+105+48*(m-1)+29)=-kbr(9)*y(NCom*L_layers+105+48*(m-1)+29)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(56)*y(NCom*L_layers+105+48*(m-1)+29)*allCI(L_layers+m)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+48*(m-1)+43)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_s*kbr(10)*y(NCom*L_layers+105+48*(m-1)+30)*y(NCom*L_layers+105+48*(m-1)+26);
%Product C
Pr(NCom*L_layers+105+48*(m-1)+30)=-kbr(10)*y(NCom*L_layers+105+48*(m-1)+30)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(57)*y(NCom*L_layers+105+48*(m-1)+30)*allCI(L_layers+m)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+48*(m-1)+43)*y(NCom*L_layers+105+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_s*kbr(12)*y(NCom*L_layers+105+48*(m-1)+31)*y(NCom*L_layers+105+48*(m-1)+26);
%Product D
Pr(NCom*L_layers+105+48*(m-1)+31)=-kbr(12)*y(NCom*L_layers+105+48*(m-1)+31)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(58)*y(NCom*L_layers+105+48*(m-1)+31)*allCI(L_layers+m)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26);
%SO or HP10
Pr(NCom*L_layers+105+48*(m-1)+32)=-kbr(73)*y(NCom*L_layers+105+48*(m-1)+32)*y(NCom*L_layers+105+48*(m-1)+26)+1*kbr(35)*y(NCom*L_layers+105+48*(m-1)+13)*allcarbonyl(L_layers+m)+1*kbr(49)*y(NCom*L_layers+105+48*(m-1)+20)*allCI(L_layers+m)+1*kbr(94)*y(NCom*L_layers+105+48*(m-1)+13)*y(NCom*L_layers+105+48*(m-1)+5);
%SO or HP14
Pr(NCom*L_layers+105+48*(m-1)+33)=-kbr(74)*y(NCom*L_layers+105+48*(m-1)+33)*y(NCom*L_layers+105+48*(m-1)+26)+1*kbr(39)*y(NCom*L_layers+105+48*(m-1)+14)*allcarbonyl(L_layers+m)+1*kbr(50)*y(NCom*L_layers+105+48*(m-1)+45)*allCI(L_layers+m)+1*kbr(95)*y(NCom*L_layers+105+48*(m-1)+14)*y(NCom*L_layers+105+48*(m-1)+5);
%SO or HP2
Pr(NCom*L_layers+105+48*(m-1)+34)=-kbr(83)*y(NCom*L_layers+105+48*(m-1)+34)*allCI(L_layers+m)+(1/2)*ratio_p*kbr(69)*y(NCom*L_layers+105+48*(m-1)+38)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_p*kbr(70)*y(NCom*L_layers+105+48*(m-1)+39)*y(NCom*L_layers+105+48*(m-1)+26)+1*kbr(75)*y(NCom*L_layers+105+48*(m-1)+18)*y(NCom*L_layers+105+48*(m-1)+21)+1*kbr(76)*y(NCom*L_layers+105+48*(m-1)+18)*y(NCom*L_layers+105+48*(m-1)+26);
%SO or HP3
Pr(NCom*L_layers+105+48*(m-1)+35)=-kbr(84)*y(NCom*L_layers+105+48*(m-1)+35)*allCI(L_layers+m)+(1/2)*ratio_s*kbr(71)*y(NCom*L_layers+105+48*(m-1)+40)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_s*kbr(74)*y(NCom*L_layers+105+48*(m-1)+33)*y(NCom*L_layers+105+48*(m-1)+26);
%SO or HP4
Pr(NCom*L_layers+105+48*(m-1)+36)=-kbr(85)*y(NCom*L_layers+105+48*(m-1)+36)*allCI(L_layers+m)+1*kbr(23)*y(NCom*L_layers+105+48*(m-1)+10)*allcarbonyl(L_layers+m)+(1/2)*ratio_s*kbr(68)*y(NCom*L_layers+105+48*(m-1)+37)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_s*kbr(72)*y(NCom*L_layers+105+48*(m-1)+41)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_s*kbr(73)*y(NCom*L_layers+105+48*(m-1)+32)*y(NCom*L_layers+105+48*(m-1)+26)+1*kbr(91)*y(NCom*L_layers+105+48*(m-1)+10)*y(NCom*L_layers+105+48*(m-1)+5);
%SO or HP5
Pr(NCom*L_layers+105+48*(m-1)+37)=-kbr(68)*y(NCom*L_layers+105+48*(m-1)+37)*y(NCom*L_layers+105+48*(m-1)+26)+1*kbr(27)*y(NCom*L_layers+105+48*(m-1)+12)*allcarbonyl(L_layers+m)+1*kbr(48)*y(NCom*L_layers+105+48*(m-1)+4)*allCI(L_layers+m)+1*kbr(92)*y(NCom*L_layers+105+48*(m-1)+12)*y(NCom*L_layers+105+48*(m-1)+5);
%SO or HP6
Pr(NCom*L_layers+105+48*(m-1)+38)=-kbr(69)*y(NCom*L_layers+105+48*(m-1)+38)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(86)*y(NCom*L_layers+105+48*(m-1)+38)*allCI(L_layers+m)+(1/2)*kbr(53)*y(NCom*L_layers+105+48*(m-1)+2)*allCI(L_layers+m)+1*kbr(79)*y(NCom*L_layers+105+48*(m-1)+19)*y(NCom*L_layers+105+48*(m-1)+21)+1*kbr(80)*y(NCom*L_layers+105+48*(m-1)+19)*y(NCom*L_layers+105+48*(m-1)+26);
%SO or HP7
Pr(NCom*L_layers+105+48*(m-1)+39)=-kbr(70)*y(NCom*L_layers+105+48*(m-1)+39)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(87)*y(NCom*L_layers+105+48*(m-1)+39)*allCI(L_layers+m)+(1/2)*kbr(54)*y(NCom*L_layers+105+48*(m-1)+1)*allCI(L_layers+m);
%SO or HP8
Pr(NCom*L_layers+105+48*(m-1)+40)=-kbr(71)*y(NCom*L_layers+105+48*(m-1)+40)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(88)*y(NCom*L_layers+105+48*(m-1)+40)*allCI(L_layers+m)+(1/2)*kbr(54)*y(NCom*L_layers+105+48*(m-1)+1)*allCI(L_layers+m)+(1/6)*ratio_s*kbr(74)*y(NCom*L_layers+105+48*(m-1)+33)*y(NCom*L_layers+105+48*(m-1)+26);
%SO or HP9
Pr(NCom*L_layers+105+48*(m-1)+41)=-kbr(72)*y(NCom*L_layers+105+48*(m-1)+41)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(89)*y(NCom*L_layers+105+48*(m-1)+41)*allCI(L_layers+m)+1*kbr(31)*y(NCom*L_layers+105+48*(m-1)+11)*allcarbonyl(L_layers+m)+(1/2)*kbr(53)*y(NCom*L_layers+105+48*(m-1)+2)*allCI(L_layers+m)+(1/4)*ratio_s*kbr(73)*y(NCom*L_layers+105+48*(m-1)+32)*y(NCom*L_layers+105+48*(m-1)+26)+1*kbr(93)*y(NCom*L_layers+105+48*(m-1)+11)*y(NCom*L_layers+105+48*(m-1)+5);
%Squalene
Pr(NCom*L_layers+105+48*(m-1)+42)=-kbr(1)*y(NCom*L_layers+105+48*(m-1)+42)*y(NCom*L_layers+105+48*(m-1)+26);
%TOP
Pr(NCom*L_layers+105+48*(m-1)+43)=-kbr(8)*y(NCom*L_layers+105+48*(m-1)+43)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(51)*y(NCom*L_layers+105+48*(m-1)+43)*allCI(L_layers+m)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+48*(m-1)+42)*y(NCom*L_layers+105+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26)+1*kbr(40)*y(NCom*L_layers+105+48*(m-1)+15)*y(NCom*L_layers+105+48*(m-1)+21)+1*kbr(41)*y(NCom*L_layers+105+48*(m-1)+15)*y(NCom*L_layers+105+48*(m-1)+26);
%TOT
Pr(NCom*L_layers+105+48*(m-1)+44)=-kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(52)*y(NCom*L_layers+105+48*(m-1)+44)*allCI(L_layers+m)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+48*(m-1)+42)*y(NCom*L_layers+105+48*(m-1)+26)+1*kbr(44)*y(NCom*L_layers+105+48*(m-1)+16)*y(NCom*L_layers+105+48*(m-1)+21)+1*kbr(45)*y(NCom*L_layers+105+48*(m-1)+16)*y(NCom*L_layers+105+48*(m-1)+26);
%TTT
Pr(NCom*L_layers+105+48*(m-1)+45)=-kbr(4)*y(NCom*L_layers+105+48*(m-1)+45)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(50)*y(NCom*L_layers+105+48*(m-1)+45)*allCI(L_layers+m)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+48*(m-1)+42)*y(NCom*L_layers+105+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+48*(m-1)+43)*y(NCom*L_layers+105+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26)+1*kbr(36)*y(NCom*L_layers+105+48*(m-1)+14)*y(NCom*L_layers+105+48*(m-1)+21)+1*kbr(37)*y(NCom*L_layers+105+48*(m-1)+14)*y(NCom*L_layers+105+48*(m-1)+26);
%acetone
Pr(NCom*L_layers+105+48*(m-1)+46)=+(1/6)*ratio_p*kbr(1)*y(NCom*L_layers+105+48*(m-1)+42)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_p*kbr(2)*y(NCom*L_layers+105+48*(m-1)+4)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_p*kbr(3)*y(NCom*L_layers+105+48*(m-1)+20)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_p*kbr(4)*y(NCom*L_layers+105+48*(m-1)+45)*y(NCom*L_layers+105+48*(m-1)+26)+(1/8)*ratio_p*kbr(8)*y(NCom*L_layers+105+48*(m-1)+43)*y(NCom*L_layers+105+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+48*(m-1)+44)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_p*kbr(13)*y(NCom*L_layers+105+48*(m-1)+24)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_p*kbr(14)*y(NCom*L_layers+105+48*(m-1)+25)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_p*kbr(15)*y(NCom*L_layers+105+48*(m-1)+8)*y(NCom*L_layers+105+48*(m-1)+26)+1*kbr(16)*y(NCom*L_layers+105+48*(m-1)+9)*y(NCom*L_layers+105+48*(m-1)+21)+1*kbr(17)*y(NCom*L_layers+105+48*(m-1)+9)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_p*kbr(68)*y(NCom*L_layers+105+48*(m-1)+37)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_p*kbr(73)*y(NCom*L_layers+105+48*(m-1)+32)*y(NCom*L_layers+105+48*(m-1)+26)+(1/6)*ratio_p*kbr(74)*y(NCom*L_layers+105+48*(m-1)+33)*y(NCom*L_layers+105+48*(m-1)+26);
%1,4 butanedial
Pr(NCom*L_layers+105+48*(m-1)+47)=+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+48*(m-1)+45)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_s*kbr(6)*y(NCom*L_layers+105+48*(m-1)+1)*y(NCom*L_layers+105+48*(m-1)+26)+(1/4)*ratio_s*kbr(7)*y(NCom*L_layers+105+48*(m-1)+28)*y(NCom*L_layers+105+48*(m-1)+26)+(1/2)*ratio_s*kbr(70)*y(NCom*L_layers+105+48*(m-1)+39)*y(NCom*L_layers+105+48*(m-1)+26);
%Carbonyl products
Pr(NCom*L_layers+105+48*(m-1)+48)=kbr(101)*y(NCom*L_layers+105+48*(m-1)+17)*y(NCom*L_layers+105+48*(m-1)+21)+kbr(102)*y(NCom*L_layers+105+48*(m-1)+17)*y(NCom*L_layers+105+48*(m-1)+26)-kbr(106)*y(NCom*L_layers+105+48*(m-1)+48)*allCI(L_layers+m);    
end

%%%%%%%------------In the stratum corneum ------------%%%%%%%
for m=1:sc_layers
    %Total CI concentration (cm-3)
    allCI(L_layers+oil_layers+m)=y(NCom*L_layers+105+oil_layers*48+48*(m-1)+9)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+10)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+11)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+12)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+13)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+14)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+15)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+16)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+17);
    %Total carbonyl concentration (cm-3)
    allcarbonyl(L_layers+oil_layers+m)=2*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+1)+2*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+2)+2*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+3)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+4)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+6)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+7)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+20)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+22)+2*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+23)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+24)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+25)+2*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+28)+2*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+29)+2*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+30)+2*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+31)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+34)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+35)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+36)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+38)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+39)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+40)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+41)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+45)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+46)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+47)+y(NCom*L_layers+105+oil_layers*48+48*(m-1)+48);

%4-MOD
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+1)=-kbr(6)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(54)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+1)*allCI(L_layers+oil_layers+m)+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(7)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+28)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+2*(1/4)*ratio_s*kbr(9)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+29)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%4-MON
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+2)=-kbr(5)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+2)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(53)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+2)*allCI(L_layers+oil_layers+m)+(1/4)*ratio_s*kbr(3)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+20)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(7)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+28)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_p*kbr(10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+31)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+1*kbr(28)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)+1*kbr(29)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%4-OPA
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+3)=+(1/2)*ratio_s*kbr(2)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+4)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(3)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+20)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+2*(1/2)*(ratio_p/2+ratio_s/2)*kbr(5)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+2)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_p*kbr(6)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(7)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+28)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/8)*ratio_p*kbr(8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+2*(1/4)*ratio_s*kbr(9)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+29)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+2*(1/6)*ratio_p*kbr(10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+31)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+1*kbr(20)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)+1*kbr(21)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(69)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+38)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_p*kbr(71)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+40)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_p*kbr(72)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+41)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%6-MHO
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+4)=-kbr(2)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+4)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(48)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+4)*allCI(L_layers+oil_layers+m)+(1/6)*ratio_p*kbr(1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(3)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+20)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_p*kbr(4)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/8)*ratio_p*kbr(8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(14)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+25)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_p*kbr(15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+1*kbr(24)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)+1*kbr(25)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(73)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+32)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_p*kbr(74)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%Acids
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)=-kbr(90)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+9)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)-kbr(91)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)-kbr(92)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)-kbr(93)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)-kbr(94)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)-kbr(95)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)-kbr(96)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)-kbr(97)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+16)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)-kbr(98)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+18)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)-kbr(99)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+19)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)-kbr(105)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)*allCI(L_layers+oil_layers+m)+kbr(103)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+17);
%CA1
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+6)=-kbr(59)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+6)*allCI(L_layers+oil_layers+m);
%CA2
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+7)=-kbr(60)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+7)*allCI(L_layers+oil_layers+m)+(1/6)*ratio_s*kbr(15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%CA9
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+8)=-kbr(15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+1*kbr(38)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+14);
%CI1
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+9)=-kbr(16)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+9)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(17)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+9)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(18)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+9)-kbr(19)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+9)*allcarbonyl(L_layers+oil_layers+m)-kbr(90)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+9)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(2)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+4)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(3)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+20)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(13)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+24)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(14)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+25)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(68)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+37)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(73)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+32)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(74)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%CI12
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+10)=-kbr(20)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(21)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(22)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+10)-kbr(23)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+10)*allcarbonyl(L_layers+oil_layers+m)-kbr(91)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)+(1/2)*ratio_s*kbr(5)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+2)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(6)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(7)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+28)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+2*(1/4)*ratio_s*kbr(9)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+29)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+2*(1/6)*ratio_s*kbr(10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+31)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(71)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+40)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(72)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+41)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%CI16
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+11)=-kbr(28)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(29)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(30)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+11)-kbr(31)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+11)*allcarbonyl(L_layers+oil_layers+m)-kbr(93)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)+(1/4)*ratio_s*kbr(7)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+28)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+31)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%CI2
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+12)=-kbr(24)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(25)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(26)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+12)-kbr(27)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+12)*allcarbonyl(L_layers+oil_layers+m)-kbr(92)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(3)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+20)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(14)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+25)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(73)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+32)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(74)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%CI3
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+13)=-kbr(32)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(33)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(34)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+13)-kbr(35)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+13)*allcarbonyl(L_layers+oil_layers+m)-kbr(94)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(74)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%CI4
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+14)=-kbr(36)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(37)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(38)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+14)-kbr(39)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+14)*allcarbonyl(L_layers+oil_layers+m)-kbr(95)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)+(1/6)*ratio_p*kbr(1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/8)*ratio_p*kbr(8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%CI5
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+15)=-kbr(40)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(41)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(42)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+15)-kbr(43)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+15)*allcarbonyl(L_layers+oil_layers+m)-kbr(96)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)+(1/6)*ratio_p*kbr(1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%CI6
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+16)=-kbr(44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+16)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(45)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+16)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(46)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+16)-kbr(47)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+16)*allcarbonyl(L_layers+oil_layers+m)-kbr(97)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+16)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)+(1/6)*ratio_p*kbr(1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%CIDB
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+17)=-kbr(101)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+17)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(102)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+17)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(103)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+17)-kbr(104)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+17)*allcarbonyl(L_layers+oil_layers+m)+1*kbr(100)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+27)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%CISOorHP2
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+18)=-kbr(75)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+18)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(76)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+18)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(77)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+18)-kbr(78)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+18)*allcarbonyl(L_layers+oil_layers+m)-kbr(98)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+18)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5)+(1/2)*kbr(69)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+38)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*kbr(70)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+39)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%CISOorHP5
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+19)=-kbr(79)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+19)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(80)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+19)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(81)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+19)-kbr(82)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+19)*allcarbonyl(L_layers+oil_layers+m)-kbr(99)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+19)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5);
%Geranyl acetone
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+20)=-kbr(3)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+20)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(49)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+20)*allCI(L_layers+oil_layers+m)+(1/6)*kbr(1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*kbr(4)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/8)*kbr(8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/10)*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*kbr(15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+1*kbr(32)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)+1*kbr(33)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*kbr(74)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%H2O
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)=-kbr(16)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+9)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(20)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(24)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(28)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(32)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(36)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(40)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+16)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(75)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+18)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(79)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+19)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)-kbr(101)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+17)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21);
%HK1
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+22)=+1*kbr(18)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+9);
%HK2
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+23)=-kbr(64)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+23)*allCI(L_layers+oil_layers+m)+(1/2)*ratio_s*kbr(13)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+24)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(14)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+25)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+1*kbr(22)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+10);
%HK3
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+24)=-kbr(13)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+24)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(65)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+24)*allCI(L_layers+oil_layers+m)+1*kbr(26)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+12);
%HK5
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+25)=-kbr(14)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+25)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(67)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+25)*allCI(L_layers+oil_layers+m)+1*kbr(34)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+13);
%O3
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)=-kbr(1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(2)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+4)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(3)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+20)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(4)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(5)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+2)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(6)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(7)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+28)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(9)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+29)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+31)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(13)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+24)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(14)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+25)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(17)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+9)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(21)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(25)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(29)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(33)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(37)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(41)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(45)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+16)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(68)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+37)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(69)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+38)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(70)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+39)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(71)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+40)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(72)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+41)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(73)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+32)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(74)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(76)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+18)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(80)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+19)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(100)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+27)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(102)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+17)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%Other double bonds
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+27)=-kbr(100)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+27)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%Product A
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+28)=-kbr(7)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+28)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(55)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+28)*allCI(L_layers+oil_layers+m)+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+31)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%Product B
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+29)=-kbr(9)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+29)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(56)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+29)*allCI(L_layers+oil_layers+m)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%Product C
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+30)=-kbr(10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(57)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+30)*allCI(L_layers+oil_layers+m)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+31)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%Product D
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+31)=-kbr(12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+31)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(58)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+31)*allCI(L_layers+oil_layers+m)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%SO or HP10
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+32)=-kbr(73)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+32)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+1*kbr(35)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+13)*allcarbonyl(L_layers+oil_layers+m)+1*kbr(49)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+20)*allCI(L_layers+oil_layers+m)+1*kbr(94)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5);
%SO or HP14
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+33)=-kbr(74)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+1*kbr(39)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+14)*allcarbonyl(L_layers+oil_layers+m)+1*kbr(50)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+45)*allCI(L_layers+oil_layers+m)+1*kbr(95)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5);
%SO or HP2
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+34)=-kbr(83)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+34)*allCI(L_layers+oil_layers+m)+(1/2)*ratio_p*kbr(69)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+38)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_p*kbr(70)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+39)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+1*kbr(75)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+18)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)+1*kbr(76)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+18)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%SO or HP3
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+35)=-kbr(84)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+35)*allCI(L_layers+oil_layers+m)+(1/2)*ratio_s*kbr(71)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+40)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(74)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%SO or HP4
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+36)=-kbr(85)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+36)*allCI(L_layers+oil_layers+m)+1*kbr(23)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+10)*allcarbonyl(L_layers+oil_layers+m)+(1/2)*ratio_s*kbr(68)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+37)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(72)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+41)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(73)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+32)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+1*kbr(91)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5);
%SO or HP5
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+37)=-kbr(68)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+37)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+1*kbr(27)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+12)*allcarbonyl(L_layers+oil_layers+m)+1*kbr(48)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+4)*allCI(L_layers+oil_layers+m)+1*kbr(92)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5);
%SO or HP6
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+38)=-kbr(69)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+38)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(86)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+38)*allCI(L_layers+oil_layers+m)+(1/2)*kbr(53)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+2)*allCI(L_layers+oil_layers+m)+1*kbr(79)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+19)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)+1*kbr(80)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+19)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%SO or HP7
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+39)=-kbr(70)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+39)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(87)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+39)*allCI(L_layers+oil_layers+m)+(1/2)*kbr(54)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+1)*allCI(L_layers+oil_layers+m);
%SO or HP8
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+40)=-kbr(71)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+40)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(88)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+40)*allCI(L_layers+oil_layers+m)+(1/2)*kbr(54)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+1)*allCI(L_layers+oil_layers+m)+(1/6)*ratio_s*kbr(74)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%SO or HP9
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+41)=-kbr(72)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+41)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(89)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+41)*allCI(L_layers+oil_layers+m)+1*kbr(31)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+11)*allcarbonyl(L_layers+oil_layers+m)+(1/2)*kbr(53)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+2)*allCI(L_layers+oil_layers+m)+(1/4)*ratio_s*kbr(73)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+32)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+1*kbr(93)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+5);
%Squalene
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+42)=-kbr(1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%TOP
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)=-kbr(8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(51)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)*allCI(L_layers+oil_layers+m)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+1*kbr(40)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)+1*kbr(41)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%TOT
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)=-kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(52)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*allCI(L_layers+oil_layers+m)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+1*kbr(44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+16)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)+1*kbr(45)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+16)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%TTT
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+45)=-kbr(4)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(50)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+45)*allCI(L_layers+oil_layers+m)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+1*kbr(36)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)+1*kbr(37)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%acetone
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+46)=+(1/6)*ratio_p*kbr(1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_p*kbr(2)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+4)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(3)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+20)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_p*kbr(4)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/8)*ratio_p*kbr(8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_p*kbr(13)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+24)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(14)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+25)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_p*kbr(15)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+1*kbr(16)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+9)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)+1*kbr(17)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+9)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_p*kbr(68)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+37)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(73)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+32)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/6)*ratio_p*kbr(74)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%1,4 butanedial
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+47)=+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(6)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+1)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(7)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+28)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(70)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+39)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26);
%Carbonyl products
Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+48)=kbr(101)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+17)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+21)+kbr(102)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+17)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+26)-kbr(106)*y(NCom*L_layers+105+oil_layers*48+48*(m-1)+48)*allCI(L_layers+oil_layers+m);        
end

%%%%%%%------------In the viable epidermis ------------%%%%%%%
for m=1:ve_layers
    %Total CI concentration (cm-3)
    allCI(L_layers+oil_layers+sc_layers+m)=y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+9)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+10)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+11)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+12)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+13)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+14)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+15)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+16)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+17);
    %Total carbonyl concentration (cm-3)
    allcarbonyl(L_layers+oil_layers+sc_layers+m)=2*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+1)+2*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+2)+2*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+3)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+4)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+6)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+7)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+20)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+22)+2*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+23)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+24)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+25)+2*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+28)+2*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+29)+2*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+30)+2*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+31)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+34)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+35)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+36)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+38)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+39)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+40)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+41)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+45)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+46)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+47)+y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+48);

%4-MOD
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+1)=-kbr(6)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(54)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+1)*allCI(L_layers+oil_layers+sc_layers+m)+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(7)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+28)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+2*(1/4)*ratio_s*kbr(9)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+29)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%4-MON
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+2)=-kbr(5)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+2)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(53)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+2)*allCI(L_layers+oil_layers+sc_layers+m)+(1/4)*ratio_s*kbr(3)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+20)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(7)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+28)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_p*kbr(10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+31)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+1*kbr(28)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)+1*kbr(29)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%4-OPA
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+3)=+(1/2)*ratio_s*kbr(2)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+4)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(3)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+20)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+2*(1/2)*(ratio_p/2+ratio_s/2)*kbr(5)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+2)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_p*kbr(6)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(7)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+28)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/8)*ratio_p*kbr(8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+2*(1/4)*ratio_s*kbr(9)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+29)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+2*(1/6)*ratio_p*kbr(10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+31)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+1*kbr(20)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)+1*kbr(21)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(69)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+38)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_p*kbr(71)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+40)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_p*kbr(72)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+41)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%6-MHO
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+4)=-kbr(2)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+4)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(48)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+4)*allCI(L_layers+oil_layers+sc_layers+m)+(1/6)*ratio_p*kbr(1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(3)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+20)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_p*kbr(4)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/8)*ratio_p*kbr(8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(14)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+25)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_p*kbr(15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+1*kbr(24)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)+1*kbr(25)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(73)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+32)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_p*kbr(74)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%Acids
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)=-kbr(90)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+9)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)-kbr(91)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)-kbr(92)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)-kbr(93)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)-kbr(94)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)-kbr(95)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)-kbr(96)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)-kbr(97)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+16)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)-kbr(98)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+18)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)-kbr(99)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+19)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)-kbr(105)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)*allCI(L_layers+oil_layers+sc_layers+m)+kbr(103)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+17);
%CA1
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+6)=-kbr(59)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+6)*allCI(L_layers+oil_layers+sc_layers+m);
%CA2
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+7)=-kbr(60)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+7)*allCI(L_layers+oil_layers+sc_layers+m)+(1/6)*ratio_s*kbr(15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%CA9
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+8)=-kbr(15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+1*kbr(38)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+14);
%CI1
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+9)=-kbr(16)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+9)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(17)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+9)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(18)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+9)-kbr(19)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+9)*allcarbonyl(L_layers+oil_layers+sc_layers+m)-kbr(90)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+9)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(2)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+4)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(3)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+20)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(13)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+24)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(14)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+25)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(68)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+37)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(73)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+32)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(74)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%CI12
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+10)=-kbr(20)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(21)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(22)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+10)-kbr(23)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+10)*allcarbonyl(L_layers+oil_layers+sc_layers+m)-kbr(91)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)+(1/2)*ratio_s*kbr(5)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+2)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(6)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(7)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+28)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+2*(1/4)*ratio_s*kbr(9)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+29)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+2*(1/6)*ratio_s*kbr(10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+31)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(71)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+40)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(72)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+41)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%CI16
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+11)=-kbr(28)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(29)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(30)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+11)-kbr(31)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+11)*allcarbonyl(L_layers+oil_layers+sc_layers+m)-kbr(93)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)+(1/4)*ratio_s*kbr(7)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+28)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+31)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%CI2
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+12)=-kbr(24)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(25)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(26)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+12)-kbr(27)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+12)*allcarbonyl(L_layers+oil_layers+sc_layers+m)-kbr(92)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(3)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+20)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(14)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+25)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(73)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+32)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(74)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%CI3
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+13)=-kbr(32)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(33)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(34)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+13)-kbr(35)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+13)*allcarbonyl(L_layers+oil_layers+sc_layers+m)-kbr(94)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(74)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%CI4
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+14)=-kbr(36)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(37)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(38)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+14)-kbr(39)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+14)*allcarbonyl(L_layers+oil_layers+sc_layers+m)-kbr(95)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)+(1/6)*ratio_p*kbr(1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/8)*ratio_p*kbr(8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%CI5
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+15)=-kbr(40)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(41)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(42)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+15)-kbr(43)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+15)*allcarbonyl(L_layers+oil_layers+sc_layers+m)-kbr(96)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)+(1/6)*ratio_p*kbr(1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%CI6
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+16)=-kbr(44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+16)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(45)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+16)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(46)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+16)-kbr(47)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+16)*allcarbonyl(L_layers+oil_layers+sc_layers+m)-kbr(97)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+16)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)+(1/6)*ratio_p*kbr(1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%CIDB
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+17)=-kbr(101)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+17)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(102)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+17)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(103)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+17)-kbr(104)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+17)*allcarbonyl(L_layers+oil_layers+sc_layers+m)+1*kbr(100)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+27)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%CISOorHP2
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+18)=-kbr(75)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+18)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(76)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+18)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(77)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+18)-kbr(78)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+18)*allcarbonyl(L_layers+oil_layers+sc_layers+m)-kbr(98)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+18)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5)+(1/2)*kbr(69)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+38)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*kbr(70)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+39)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%CISOorHP5
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+19)=-kbr(79)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+19)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(80)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+19)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(81)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+19)-kbr(82)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+19)*allcarbonyl(L_layers+oil_layers+sc_layers+m)-kbr(99)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+19)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5);
%Geranyl acetone
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+20)=-kbr(3)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+20)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(49)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+20)*allCI(L_layers+oil_layers+sc_layers+m)+(1/6)*kbr(1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*kbr(4)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/8)*kbr(8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/10)*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*kbr(15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+1*kbr(32)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)+1*kbr(33)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*kbr(74)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%H2O
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)=-kbr(16)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+9)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(20)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(24)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(28)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(32)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(36)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(40)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+16)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(75)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+18)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(79)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+19)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)-kbr(101)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+17)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21);
%HK1
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+22)=+1*kbr(18)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+9);
%HK2
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+23)=-kbr(64)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+23)*allCI(L_layers+oil_layers+sc_layers+m)+(1/2)*ratio_s*kbr(13)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+24)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(14)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+25)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+1*kbr(22)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+10);
%HK3
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+24)=-kbr(13)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+24)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(65)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+24)*allCI(L_layers+oil_layers+sc_layers+m)+1*kbr(26)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+12);
%HK5
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+25)=-kbr(14)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+25)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(67)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+25)*allCI(L_layers+oil_layers+sc_layers+m)+1*kbr(34)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+13);
%O3
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)=-kbr(1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(2)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+4)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(3)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+20)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(4)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(5)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+2)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(6)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(7)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+28)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(9)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+29)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+31)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(13)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+24)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(14)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+25)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(17)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+9)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(21)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(25)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(29)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(33)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(37)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(41)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(45)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+16)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(68)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+37)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(69)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+38)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(70)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+39)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(71)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+40)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(72)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+41)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(73)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+32)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(74)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(76)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+18)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(80)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+19)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(100)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+27)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(102)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+17)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%Other double bonds
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+27)=-kbr(100)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+27)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%Product A
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+28)=-kbr(7)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+28)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(55)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+28)*allCI(L_layers+oil_layers+sc_layers+m)+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+31)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%Product B
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+29)=-kbr(9)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+29)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(56)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+29)*allCI(L_layers+oil_layers+sc_layers+m)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%Product C
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+30)=-kbr(10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+30)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(57)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+30)*allCI(L_layers+oil_layers+sc_layers+m)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+31)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%Product D
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+31)=-kbr(12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+31)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(58)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+31)*allCI(L_layers+oil_layers+sc_layers+m)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%SO or HP10
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+32)=-kbr(73)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+32)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+1*kbr(35)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+13)*allcarbonyl(L_layers+oil_layers+sc_layers+m)+1*kbr(49)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+20)*allCI(L_layers+oil_layers+sc_layers+m)+1*kbr(94)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+13)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5);
%SO or HP14
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+33)=-kbr(74)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+1*kbr(39)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+14)*allcarbonyl(L_layers+oil_layers+sc_layers+m)+1*kbr(50)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+45)*allCI(L_layers+oil_layers+sc_layers+m)+1*kbr(95)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5);
%SO or HP2
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+34)=-kbr(83)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+34)*allCI(L_layers+oil_layers+sc_layers+m)+(1/2)*ratio_p*kbr(69)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+38)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_p*kbr(70)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+39)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+1*kbr(75)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+18)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)+1*kbr(76)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+18)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%SO or HP3
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+35)=-kbr(84)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+35)*allCI(L_layers+oil_layers+sc_layers+m)+(1/2)*ratio_s*kbr(71)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+40)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_s*kbr(74)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%SO or HP4
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+36)=-kbr(85)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+36)*allCI(L_layers+oil_layers+sc_layers+m)+1*kbr(23)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+10)*allcarbonyl(L_layers+oil_layers+sc_layers+m)+(1/2)*ratio_s*kbr(68)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+37)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(72)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+41)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(73)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+32)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+1*kbr(91)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+10)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5);
%SO or HP5
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+37)=-kbr(68)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+37)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+1*kbr(27)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+12)*allcarbonyl(L_layers+oil_layers+sc_layers+m)+1*kbr(48)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+4)*allCI(L_layers+oil_layers+sc_layers+m)+1*kbr(92)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+12)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5);
%SO or HP6
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+38)=-kbr(69)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+38)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(86)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+38)*allCI(L_layers+oil_layers+sc_layers+m)+(1/2)*kbr(53)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+2)*allCI(L_layers+oil_layers+sc_layers+m)+1*kbr(79)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+19)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)+1*kbr(80)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+19)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%SO or HP7
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+39)=-kbr(70)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+39)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(87)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+39)*allCI(L_layers+oil_layers+sc_layers+m)+(1/2)*kbr(54)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+1)*allCI(L_layers+oil_layers+sc_layers+m);
%SO or HP8
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+40)=-kbr(71)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+40)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(88)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+40)*allCI(L_layers+oil_layers+sc_layers+m)+(1/2)*kbr(54)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+1)*allCI(L_layers+oil_layers+sc_layers+m)+(1/6)*ratio_s*kbr(74)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%SO or HP9
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+41)=-kbr(72)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+41)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(89)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+41)*allCI(L_layers+oil_layers+sc_layers+m)+1*kbr(31)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+11)*allcarbonyl(L_layers+oil_layers+sc_layers+m)+(1/2)*kbr(53)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+2)*allCI(L_layers+oil_layers+sc_layers+m)+(1/4)*ratio_s*kbr(73)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+32)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+1*kbr(93)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+5);
%Squalene
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+42)=-kbr(1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%TOP
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)=-kbr(8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(51)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)*allCI(L_layers+oil_layers+sc_layers+m)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+1*kbr(40)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)+1*kbr(41)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%TOT
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)=-kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(52)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*allCI(L_layers+oil_layers+sc_layers+m)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+1*kbr(44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+16)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)+1*kbr(45)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+16)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%TTT
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+45)=-kbr(4)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(50)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+45)*allCI(L_layers+oil_layers+sc_layers+m)+(1/6)*ratio_s*kbr(1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/8)*ratio_s*kbr(8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/10)*ratio_s*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+1*kbr(36)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)+1*kbr(37)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+14)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%acetone
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+46)=+(1/6)*ratio_p*kbr(1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+42)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_p*kbr(2)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+4)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(3)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+20)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_p*kbr(4)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/8)*ratio_p*kbr(8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+43)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/10)*ratio_p*kbr(11)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+44)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_p*kbr(13)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+24)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(14)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+25)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_p*kbr(15)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+8)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+1*kbr(16)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+9)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)+1*kbr(17)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+9)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_p*kbr(68)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+37)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_p*kbr(73)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+32)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/6)*ratio_p*kbr(74)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+33)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%1,4 butanedial
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+47)=+(1/6)*ratio_s*kbr(4)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+45)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(6)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+1)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/4)*ratio_s*kbr(7)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+28)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)+(1/2)*ratio_s*kbr(70)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+39)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26);
%Carbonyl products
Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+48)=kbr(101)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+17)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+21)+kbr(102)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+17)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+26)-kbr(106)*y(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+48)*allCI(L_layers+oil_layers+sc_layers+m);        
end

%%%%%%%%%%--------Differential equations: Change in concentrations over time (cm-3 s-1 unless stated)--------------%%%%%%%%%%

%boundary layer and gas phase (species that are formed but don't partition)
for i=[NCom*L_layers+7:NCom*L_layers+13,NCom*L_layers+28:NCom*L_layers+34]
    dydt(i)=Pr(i);
end
%----------------
%gas phase (SVOCs)
for i=[1:6,14:21]
    dydt(NCom*L_layers+21+i)=Pr(NCom*L_layers+21+i)-...
        Fnet(i).*S_clothing./V_room;     
end

for i=15 %H2O concentration stays constant
    dydt(NCom*L_layers+21+i)=0;     
end
%--------------
%boundary layer (SVOCs)
for i=[1:6,14:21]
    dydt(NCom*L_layers+i)=Pr(NCom*L_layers+i)+...
        (Jclothes_bl(i)-Jbl_clothes(i)).*A./(Travel_distance.*A)+...
        Fnet(i).*A./(Travel_distance.*A);       
end

%--------------
%near sace gas
for i=7:13
    %species that are formed but don't partition
dydt(NCom*L_layers+15+48+i)=Pr(NCom*L_layers+15+48+i);    
end
for i=[1:6,14:21]
    %SVOCs
dydt(NCom*L_layers+15+48+i)=Pr(NCom*L_layers+15+48+i)+...
    (Jgap_mfp(i)-Jmfp_gap(i)).*A./V_mfp(i)+...
    (Jdes(i)-Jads(i)).*A./V_mfp(i);
end

%--------------
%gap
for i=7:13
    %species that are formed but don't partition
dydt(NCom*L_layers-6+48+i)=Pr(NCom*L_layers-6+48+i);    
end
for i=[1:6,14:21]
    %SVOCs
dydt(NCom*L_layers-6+48+i)=Pr(NCom*L_layers-6+48+i)+...
    (Jcl_gap(i)-Jgap_cl(i)).*A./V_gap+...
    (Jmfp_gap(i)-Jgap_mfp(i)).*A./V_gap;    
end

%--------------
%sace (sorption layer, cm-2 s-1)
for i=7:13
    %species that are formed but don't partition
    dydt(NCom*L_layers+15+69+i)=0;
end
for i=[1:6,14:21]
    %SVOCs
    dydt(NCom*L_layers+15+69+i)=(Jads(i)-Jdes(i))+(Joil1_s(i)-Js_oil1(i));
end

%--------------
%Condensed phase clothing
%Non-volatile species
for i=[5,8:19,25,27:45]
    for m=1:L_layers
        dydt(NCom*(m-1)+i)=Pr(NCom*(m-1)+i)+...
            (Jso_cl_total(i)-Jcl_so(i,m)).*A/(V_clothes*Clothes_fraction_fibres*L_layers);
    end
end
%SVOCs 
for m=1:L_layers
for i=1:4
    dydt(NCom*(m-1)+i)=Pr(NCom*(m-1)+i)+(Jgas_clothes(i,m)-Jclothes_gas(i,m)).*A./(V_clothes.*Clothes_fraction_fibres)+...
            (Jso_cl_total(i)-Jcl_so(i,m)).*A/(V_clothes*Clothes_fraction_fibres*L_layers);
end
for i=6:7
    dydt(NCom*(m-1)+i)=Pr(NCom*(m-1)+i)+(Jgas_clothes(i-1,m)-Jclothes_gas(i-1,m)).*A./(V_clothes.*Clothes_fraction_fibres)+...
            (Jso_cl_total(i)-Jcl_so(i,m)).*A/(V_clothes*Clothes_fraction_fibres*L_layers);
end
for i=20:24
    dydt(NCom*(m-1)+i)=Pr(NCom*(m-1)+i)+(Jgas_clothes(i-6,m)-Jclothes_gas(i-6,m)).*A./(V_clothes.*Clothes_fraction_fibres)+...
            (Jso_cl_total(i)-Jcl_so(i,m)).*A/(V_clothes*Clothes_fraction_fibres*L_layers);
end
for i=26
    dydt(NCom*(m-1)+i)=Pr(NCom*(m-1)+i)+(Jgas_clothes(i-7,m)-Jclothes_gas(i-7,m)).*A./(V_clothes.*Clothes_fraction_fibres)+...
            (Jso_cl_total(i)-Jcl_so(i,m)).*A/(V_clothes*Clothes_fraction_fibres*L_layers);
end
for i=46:47
    dydt(NCom*(m-1)+i)=Pr(NCom*(m-1)+i)+(Jgas_clothes(i-26,m)-Jclothes_gas(i-26,m)).*A./(V_clothes.*Clothes_fraction_fibres)+...
            (Jso_cl_total(i)-Jcl_so(i,m)).*A/(V_clothes*Clothes_fraction_fibres*L_layers);
end
end

%--------------
%Gas-phase clothing
%species that are formed but don't partition
for i=55:61
    for m=1:L_layers       
        dydt(NCom*(m-1)+i)=Pr(NCom*(m-1)+i);
    end
end

%SVOCs 
%first layer
for m=1
    for i=49:54
    dydt(NCom*(m-1)+i)=Pr(NCom*(m-1)+i)+(Jbl_clothes(i-48)-Jclothes_bl(i-48)).*A./(V_clothes.*Clothes_fraction_air)+...
        (Jclothes_clothes(i-48,2,1)-Jclothes_clothes(i-48,1,2)).*A./(V_clothes.*Clothes_fraction_air)+...
        (Jclothes_gas(i-48,m)-Jgas_clothes(i-48,m)).*A./(V_clothes.*Clothes_fraction_air);
    end
    for i=62:69
    dydt(NCom*(m-1)+i)=Pr(NCom*(m-1)+i)+(Jbl_clothes(i-48)-Jclothes_bl(i-48)).*A./(V_clothes.*Clothes_fraction_air)+...
        (Jclothes_clothes(i-48,2,1)-Jclothes_clothes(i-48,1,2)).*A./(V_clothes.*Clothes_fraction_air)+...
        (Jclothes_gas(i-48,m)-Jgas_clothes(i-48,m)).*A./(V_clothes.*Clothes_fraction_air);
    end
end
%middle layers
for m=2:L_layers-1
    for i=49:54
    dydt(NCom*(m-1)+i)=Pr(NCom*(m-1)+i)+...
        (Jclothes_clothes(i-48,m+1,m)-Jclothes_clothes(i-48,m,m+1)).*A./(V_clothes.*Clothes_fraction_air)+...
        (Jclothes_clothes(i-48,m-1,m)-Jclothes_clothes(i-48,m,m-1)).*A./(V_clothes.*Clothes_fraction_air)+...
        (Jclothes_gas(i-48,m)-Jgas_clothes(i-48,m)).*A./(V_clothes.*Clothes_fraction_air);
    end
    for i=62:69
    dydt(NCom*(m-1)+i)=Pr(NCom*(m-1)+i)+...
        (Jclothes_clothes(i-48,m+1,m)-Jclothes_clothes(i-48,m,m+1)).*A./(V_clothes.*Clothes_fraction_air)+...
        (Jclothes_clothes(i-48,m-1,m)-Jclothes_clothes(i-48,m,m-1)).*A./(V_clothes.*Clothes_fraction_air)+...
        (Jclothes_gas(i-48,m)-Jgas_clothes(i-48,m)).*A./(V_clothes.*Clothes_fraction_air);
    end
end
%final layer
for m=L_layers
    for i=49:54
    dydt(NCom*(m-1)+i)=Pr(NCom*(m-1)+i)+...
        (Jclothes_clothes(i-48,m-1,m)-Jclothes_clothes(i-48,m,m-1)).*A./(V_clothes.*Clothes_fraction_air)+...
        (Jclothes_gas(i-48,m)-Jgas_clothes(i-48,m)).*A./(V_clothes.*Clothes_fraction_air)+...
        (Jgap_cl(i-48)-Jcl_gap(i-48)).*A./(V_clothes.*Clothes_fraction_air);
    end
    for i=62:69
    dydt(NCom*(m-1)+i)=Pr(NCom*(m-1)+i)+...
        (Jclothes_clothes(i-48,m-1,m)-Jclothes_clothes(i-48,m,m-1)).*A./(V_clothes.*Clothes_fraction_air)+...
        (Jclothes_gas(i-48,m)-Jgas_clothes(i-48,m)).*A./(V_clothes.*Clothes_fraction_air)+...
        (Jgap_cl(i-48)-Jcl_gap(i-48)).*A./(V_clothes.*Clothes_fraction_air);
    end
end

%--------------
%Skin oil
%%%%first layer%%%%
%Species that are set to have a constant concentration (non-volatile)
for i=[5,27,42,48]
    dydt(NCom*L_layers+105+i)=0;
end
%Criegee intermediates
for i=9:19
    dydt(NCom*L_layers+105+i)=Pr(NCom*L_layers+105+i)+...
        (Jcl_so_total(i)/L_layers-Jso_cl_total(i)).*A/V_oil;
end
%Non-volatile species
for i=[8,25,28:41,43:45]
    dydt(NCom*L_layers+105+i)=Pr(NCom*L_layers+105+i)+...
        (Joil_oil(i,2,1)-Joil_oil(i,1,2)).*A./V_oil+...
        (Jcl_so_total(i)/L_layers-Jso_cl_total(i)).*A/V_oil;
end
%SVOCs 
for i=1:4
    dydt(NCom*L_layers+105+i)=Pr(NCom*L_layers+105+i)+...
        (Joil_oil(i,2,1)-Joil_oil(i,1,2)).*A./V_oil+...
        (Js_oil1(i)-Joil1_s(i)).*A./V_oil+...
        (Jcl_so_total(i)/L_layers-Jso_cl_total(i)).*A/V_oil;    
end
for i=6:7
    dydt(NCom*L_layers+105+i)=Pr(NCom*L_layers+105+i)+...
        (Joil_oil(i,2,1)-Joil_oil(i,1,2)).*A./V_oil+...
        (Js_oil1(i-1)-Joil1_s(i-1)).*A./V_oil+...
        (Jcl_so_total(i)/L_layers-Jso_cl_total(i)).*A/V_oil;    
end
for i=20:24
     dydt(NCom*L_layers+105+i)=Pr(NCom*L_layers+105+i)+...
        (Joil_oil(i,2,1)-Joil_oil(i,1,2)).*A./V_oil+...
        (Js_oil1(i-6)-Joil1_s(i-6)).*A./V_oil+...
        (Jcl_so_total(i)/L_layers-Jso_cl_total(i)).*A/V_oil;    
end
for i=26
     dydt(NCom*L_layers+105+i)=Pr(NCom*L_layers+105+i)+...
        (Joil_oil(i,2,1)-Joil_oil(i,1,2)).*A./V_oil+...
        (Js_oil1(i-7)-Joil1_s(i-7)).*A./V_oil+...
        (Jcl_so_total(i)/L_layers-Jso_cl_total(i)).*A/V_oil;    
end  
for i=46:47
     dydt(NCom*L_layers+105+i)=Pr(NCom*L_layers+105+i)+...
        (Joil_oil(i,2,1)-Joil_oil(i,1,2)).*A./V_oil+...
        (Js_oil1(i-26)-Joil1_s(i-26)).*A./V_oil+...
        (Jcl_so_total(i)/L_layers-Jso_cl_total(i)).*A/V_oil;    
end
%%%middle layers%%%
for m=2:oil_layers-1
    for i=[5,27,42,48]
        dydt(NCom*L_layers+105+48*(m-1)+i)=0;
    end
    for i=9:19
        dydt(NCom*L_layers+105+48*(m-1)+i)=Pr(NCom*L_layers+105+48*(m-1)+i);
    end
    for i=[1:4,6:8,20:26,28:41,43:47]
        dydt(NCom*L_layers+105+48*(m-1)+i)=Pr(NCom*L_layers+105+48*(m-1)+i)+...
        (Joil_oil(i,m-1,m)-Joil_oil(i,m,m-1)).*A./V_oil+...
        (Joil_oil(i,m+1,m)-Joil_oil(i,m,m+1)).*A./V_oil;
    end
end

%%%last layer%%%%%
    for i=[5,27,42,48]
        dydt(NCom*L_layers+105+48*(oil_layers-1)+i)=0;
    end
    for i=9:19
        dydt(NCom*L_layers+105+48*(oil_layers-1)+i)=Pr(NCom*L_layers+105+48*(oil_layers-1)+i);
    end
    for i=[1:4,6:8,20:26,28:41,43:47]
        dydt(NCom*L_layers+105+48*(oil_layers-1)+i)=Pr(NCom*L_layers+105+48*(oil_layers-1)+i)+...
        (Joil_oil(i,oil_layers-1,oil_layers)-Joil_oil(i,oil_layers,oil_layers-1)).*A./V_oil+...
        (Jsc_finaloil(i)-Jfinaloil_sc(i)).*A./V_oil;
    end

%--------------
%stratum corneum
%%%%first layer%%%%
  for i=[5,27,42,48]
      dydt(NCom*L_layers+105+oil_layers*48+i)=0;
  end
  for i=9:19
      dydt(NCom*L_layers+105+oil_layers*48+i)=Pr(NCom*L_layers+105+oil_layers*48+i);
  end
  for i=[1:4,6:8,20:26,28:41,43:47]
      dydt(NCom*L_layers+105+oil_layers*48+i)=Pr(NCom*L_layers+105+oil_layers*48+i)+...
          (Jfinaloil_sc(i)-Jsc_finaloil(i)).*A./V_sc+...
          (Jsc_sc(i,2,1)-Jsc_sc(i,1,2)).*A./V_sc;
  end
%%%middle layers%%%
for m=2:sc_layers-1
    for i=[5,27,42,48]
        dydt(NCom*L_layers+105+oil_layers*48+48*(m-1)+i)=0;
    end
    for i=9:19
        dydt(NCom*L_layers+105+oil_layers*48+48*(m-1)+i)=Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+i);
    end
    for i=[1:4,6:8,20:26,28:41,43:47]
        dydt(NCom*L_layers+105+oil_layers*48+48*(m-1)+i)=Pr(NCom*L_layers+105+oil_layers*48+48*(m-1)+i)+...
        (Jsc_sc(i,m-1,m)-Jsc_sc(i,m,m-1)).*A./V_sc+...
        (Jsc_sc(i,m+1,m)-Jsc_sc(i,m,m+1)).*A./V_sc;            
    end 
end

%%%last layer%%%%%
    for i=[5,27,42,48]
        dydt(NCom*L_layers+105+oil_layers*48+48*(sc_layers-1)+i)=0;
    end
    for i=9:19
        dydt(NCom*L_layers+105+oil_layers*48+48*(sc_layers-1)+i)=Pr(NCom*L_layers+105+oil_layers*48+48*(sc_layers-1)+i);
    end
    for i=[1:4,6:8,20:26,28:41,43:47]
        dydt(NCom*L_layers+105+oil_layers*48+48*(sc_layers-1)+i)=Pr(NCom*L_layers+105+oil_layers*48+48*(sc_layers-1)+i)+...
        (Jsc_sc(i,sc_layers-1,sc_layers)-Jsc_sc(i,sc_layers,sc_layers-1)).*A./V_sc+...
        (Jve_sc(i)-Jsc_ve(i)).*A./V_sc;            
    end 

%--------------    
%viable epidermis
%%%%first layer%%%%
for i=[5,27,42,48]
    dydt(NCom*L_layers+105+oil_layers*48+sc_layers*48+i)=0;
end
for i=9:19
    dydt(NCom*L_layers+105+oil_layers*48+sc_layers*48+i)=Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+i);
end
for i=[1:4,6:8,20:26,28:41,43:47]
    dydt(NCom*L_layers+105+oil_layers*48+sc_layers*48+i)=Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+i)+...
    (Jsc_ve(i)-Jve_sc(i)).*A./V_ve+...
    (Jve_ve(i,2,1)-Jve_ve(i,1,2)).*A./V_ve;
end
%%%middle layers%%%
for m=2:ve_layers-1
    for i=[5,27,42,48]
        dydt(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+i)=0;
    end
    for i=9:19
        dydt(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+i)=Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+i);
    end
    for i=[1:4,6:8,20:26,28:41,43:47]
        dydt(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+i)=Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(m-1)+i)+...
            (Jve_ve(i,m-1,m)-Jve_ve(i,m,m-1)).*A./V_ve+...
            (Jve_ve(i,m+1,m)-Jve_ve(i,m,m+1)).*A./V_ve;
    end
end
%%%last layer%%%%%
for i=[5,27,42,48]
    dydt(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(ve_layers-1)+1)=0;
end
for i=9:19
    dydt(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(ve_layers-1)+1)=Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(ve_layers-1)+1);
end
for i=[1:4,6:8,20:26,28:41,43:47]
    dydt(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(ve_layers-1)+1)=Pr(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*(ve_layers-1)+1)+...
    (Jve_ve(i,ve_layers-1,ve_layers)-Jve_ve(i,ve_layers,ve_layers-1)).*A./V_ve+...
        -Jve_blood(i).*A./V_ve;    
end

%--------------   
%Into the blood (s-1)
for i=[5,9:19,27,42,48]
    %Species that are not transported into the blood
    dydt(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*ve_layers+i)=0;
end
for i=[1:4,6:8,20:26,28:41,43:47]
    %Species that are transported into the blood
    dydt(NCom*L_layers+105+oil_layers*48+sc_layers*48+48*ve_layers+i)=Jve_blood(i).*A./V_ve;
end
end